/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.reactive.filter.runtime;

import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.client.runtime.AbstractTokensProducer;
import io.quarkus.oidc.client.runtime.DisabledOidcClientException;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestFilter;

public class AbstractOidcClientRequestReactiveFilter
extends AbstractTokensProducer
implements ResteasyReactiveClientRequestFilter {
    private static final Logger LOG = Logger.getLogger(AbstractOidcClientRequestReactiveFilter.class);
    private static final String BEARER_SCHEME_WITH_SPACE = "Bearer ";

    protected void initTokens() {
        if (this.earlyTokenAcquisition) {
            LOG.debug((Object)"Token acquisition will be delayed until this filter is executed to avoid blocking an IO thread");
        }
    }

    public void filter(final ResteasyReactiveClientRequestContext requestContext) {
        if (this.isClientFeatureDisabled()) {
            LOG.debug((Object)"OIDC client filter can not acquire and propagate tokens because OIDC client is disabled with `quarkus.oidc-client.enabled=false`");
            return;
        }
        requestContext.suspend();
        super.getTokens().subscribe().with((Consumer)new Consumer<Tokens>(){

            @Override
            public void accept(Tokens tokens) {
                requestContext.getHeaders().putSingle((Object)"Authorization", (Object)(AbstractOidcClientRequestReactiveFilter.BEARER_SCHEME_WITH_SPACE + tokens.getAccessToken()));
                requestContext.resume();
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                if (t instanceof DisabledOidcClientException) {
                    LOG.debug((Object)"Client is disabled, acquiring and propagating the token is not necessary");
                    requestContext.resume();
                } else {
                    LOG.debugf("Access token is not available, cause: %s, aborting the request", (Object)t.getMessage());
                    requestContext.resume(t instanceof RuntimeException ? t : new RuntimeException(t));
                }
            }
        });
    }
}

