/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive;

import io.quarkus.arc.Arc;
import io.quarkus.rest.client.reactive.HeaderContainer;
import io.quarkus.rest.client.reactive.HeaderFiller;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;

@Priority(value=-2147483648)
public class MicroProfileRestClientRequestFilter
implements ClientRequestFilter {
    private static final MultivaluedMap<String, String> EMPTY_MAP = new MultivaluedHashMap();
    private final ClientHeadersFactory clientHeadersFactory;

    public MicroProfileRestClientRequestFilter(ClientHeadersFactory clientHeadersFactory) {
        this.clientHeadersFactory = clientHeadersFactory;
    }

    public void filter(ClientRequestContext requestContext) {
        HeaderContainer headerContainer;
        HeaderFiller headerFiller = (HeaderFiller)requestContext.getProperty(HeaderFiller.class.getName());
        MultivaluedHashMap headers = new MultivaluedHashMap();
        for (Map.Entry headerEntry : requestContext.getHeaders().entrySet()) {
            headers.put(headerEntry.getKey(), MicroProfileRestClientRequestFilter.castToListOfStrings((List)headerEntry.getValue()));
        }
        if (headerFiller != null) {
            headerFiller.addHeaders((MultivaluedMap<String, String>)headers);
        }
        MultivaluedMap incomingHeaders = EMPTY_MAP;
        if (Arc.container().getActiveContext(RequestScoped.class) != null && (headerContainer = (HeaderContainer)Arc.container().instance(HeaderContainer.class, new Annotation[0]).get()) != null) {
            incomingHeaders = headerContainer.getHeaders();
        }
        if (this.clientHeadersFactory instanceof DefaultClientHeadersFactoryImpl) {
            for (Map.Entry headerEntry : headers.entrySet()) {
                requestContext.getHeaders().put(headerEntry.getKey(), MicroProfileRestClientRequestFilter.castToListOfObjects((List)headerEntry.getValue()));
            }
        }
        if (this.clientHeadersFactory != null) {
            incomingHeaders = this.clientHeadersFactory.update(incomingHeaders, (MultivaluedMap)headers);
        }
        for (Map.Entry headerEntry : incomingHeaders.entrySet()) {
            requestContext.getHeaders().put(headerEntry.getKey(), MicroProfileRestClientRequestFilter.castToListOfObjects((List)headerEntry.getValue()));
        }
    }

    private static List<String> castToListOfStrings(List<Object> values) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : values) {
            if (value instanceof String) {
                result.add((String)value);
                continue;
            }
            result.add(String.valueOf(value));
        }
        return result;
    }

    private static List<Object> castToListOfObjects(List<String> values) {
        return values;
    }
}

