/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive;

import io.quarkus.rest.client.reactive.DefaultMicroprofileRestClientExceptionMapper;
import io.quarkus.rest.client.reactive.MicroProfileRestClientResponseFilter;
import io.quarkus.rest.client.reactive.RestClientListeners;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.jboss.resteasy.reactive.client.api.InvalidRestClientDefinitionException;
import org.jboss.resteasy.reactive.client.impl.ClientBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;

public class RestClientBuilderImpl
implements RestClientBuilder {
    private static final String DEFAULT_MAPPER_DISABLED = "microprofile.rest.client.disable.default.mapper";
    private final ClientBuilder clientBuilder = new ClientBuilderImpl().withConfig((Configuration)new ConfigurationImpl(RuntimeType.CLIENT));
    private final List<ResponseExceptionMapper<?>> exceptionMappers = new ArrayList();
    private URL url;

    public RestClientBuilder baseUrl(URL url) {
        this.url = url;
        return this;
    }

    public RestClientBuilder connectTimeout(long timeout, TimeUnit timeUnit) {
        this.clientBuilder.connectTimeout(timeout, timeUnit);
        return this;
    }

    public RestClientBuilder readTimeout(long timeout, TimeUnit timeUnit) {
        this.clientBuilder.readTimeout(timeout, timeUnit);
        return this;
    }

    public RestClientBuilder sslContext(SSLContext sslContext) {
        this.clientBuilder.sslContext(sslContext);
        return this;
    }

    public RestClientBuilder trustStore(KeyStore trustStore) {
        this.clientBuilder.trustStore(trustStore);
        return this;
    }

    public RestClientBuilder keyStore(KeyStore keyStore, String keystorePassword) {
        this.clientBuilder.keyStore(keyStore, keystorePassword);
        return this;
    }

    public RestClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.clientBuilder.hostnameVerifier(hostnameVerifier);
        return this;
    }

    public RestClientBuilder executorService(ExecutorService executor) {
        throw new IllegalArgumentException("Specifying executor service is not supported. The underlying call in RestEasy Reactive is non-blocking, there is no reason to offload the call to a separate thread pool.");
    }

    public Configuration getConfiguration() {
        return this.clientBuilder.getConfiguration();
    }

    public RestClientBuilder property(String name, Object value) {
        this.clientBuilder.property(name, value);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass) {
        this.registerMpSpecificProvider(componentClass);
        this.clientBuilder.register(componentClass);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, int priority) {
        this.registerMpSpecificProvider(componentClass);
        this.clientBuilder.register(componentClass, priority);
        return this;
    }

    private void registerMpSpecificProvider(Class<?> componentClass) {
        if (ResponseExceptionMapper.class.isAssignableFrom(componentClass)) {
            try {
                this.registerMpSpecificProvider(componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to instantiate exception mapper " + componentClass + ". Does it have a public no-arg constructor?", e);
            }
        }
    }

    private void registerMpSpecificProvider(Object component) {
        if (component instanceof ResponseExceptionMapper) {
            this.exceptionMappers.add((ResponseExceptionMapper)component);
        }
    }

    public RestClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.registerMpSpecificProvider(componentClass);
        this.clientBuilder.register(componentClass, (Class[])contracts);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.registerMpSpecificProvider(componentClass);
        this.clientBuilder.register(componentClass, contracts);
        return this;
    }

    public RestClientBuilder register(Object component) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component);
        return this;
    }

    public RestClientBuilder register(Object component, int priority) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component, priority);
        return this;
    }

    public RestClientBuilder register(Object component, Class<?> ... contracts) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component, (Class[])contracts);
        return this;
    }

    public RestClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component, contracts);
        return this;
    }

    public <T> T build(Class<T> aClass) throws IllegalStateException, RestClientDefinitionException {
        if (this.url == null) {
            throw new IllegalStateException("No URL specified. Cannot build a rest client without URL");
        }
        RestClientListeners.get().forEach(listener -> listener.onNewClient(aClass, (RestClientBuilder)this));
        Object defaultMapperDisabled = this.getConfiguration().getProperty(DEFAULT_MAPPER_DISABLED);
        Boolean globallyDisabledMapper = ConfigProvider.getConfig().getOptionalValue(DEFAULT_MAPPER_DISABLED, Boolean.class).orElse(false);
        if (!(globallyDisabledMapper.booleanValue() || defaultMapperDisabled instanceof Boolean && ((Boolean)defaultMapperDisabled).booleanValue())) {
            this.exceptionMappers.add(new DefaultMicroprofileRestClientExceptionMapper());
        }
        this.exceptionMappers.sort(Comparator.comparingInt(ResponseExceptionMapper::getPriority));
        this.clientBuilder.register((Object)new MicroProfileRestClientResponseFilter(this.exceptionMappers));
        ClientImpl client = (ClientImpl)this.clientBuilder.build();
        WebTargetImpl target = null;
        try {
            target = (WebTargetImpl)client.target(this.url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid Rest Client URL: " + this.url, e);
        }
        try {
            return (T)target.proxy(aClass);
        }
        catch (InvalidRestClientDefinitionException e) {
            throw new RestClientDefinitionException((Throwable)e);
        }
    }
}

