/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class RestClientCDIDelegateBuilder {
    private static final String MP_REST = "mp-rest";
    private static final String REST_URL_FORMAT = "%s/mp-rest/url";
    private static final String REST_URI_FORMAT = "%s/mp-rest/uri";
    private static final String REST_CONNECT_TIMEOUT_FORMAT = "%s/mp-rest/connectTimeout";
    private static final String REST_READ_TIMEOUT_FORMAT = "%s/mp-rest/readTimeout";
    public static final String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
    private static final String REST_PROVIDERS = "%s/mp-rest/providers";
    private static final String REST_TRUST_STORE = "%s/mp-rest/trustStore";
    private static final String REST_TRUST_STORE_PASSWORD = "%s/mp-rest/trustStorePassword";
    private static final String REST_TRUST_STORE_TYPE = "%s/mp-rest/trustStoreType";
    private static final String REST_KEY_STORE = "%s/mp-rest/keyStore";
    private static final String REST_KEY_STORE_PASSWORD = "%s/mp-rest/keyStorePassword";
    private static final String REST_KEY_STORE_TYPE = "%s/mp-rest/keyStoreType";
    private static final String REST_HOSTNAME_VERIFIER = "%s/mp-rest/hostnameVerifier";
    private static final String REST_NOOP_HOSTNAME_VERIFIER = "io.quarkus.restclient.NoopHostnameVerifier";
    private static final String TLS_TRUST_ALL = "quarkus.tls.trust-all";
    private final Class<?> jaxrsInterface;
    private final String baseUriFromAnnotation;
    private final String propertyPrefix;

    public static Object createDelegate(Class<?> jaxrsInterface, String baseUriFromAnnotation, String propertyPrefix) {
        return new RestClientCDIDelegateBuilder(jaxrsInterface, baseUriFromAnnotation, propertyPrefix).build();
    }

    private RestClientCDIDelegateBuilder(Class<?> jaxrsInterface, String baseUriFromAnnotation, String propertyPrefix) {
        this.jaxrsInterface = jaxrsInterface;
        this.baseUriFromAnnotation = baseUriFromAnnotation;
        this.propertyPrefix = propertyPrefix;
    }

    private Object build() {
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        this.configureBaseUrl(builder);
        this.configureTimeouts(builder);
        this.configureProviders(builder);
        this.configureSsl(builder);
        Object result = builder.build(this.jaxrsInterface);
        return result;
    }

    private void configureSsl(RestClientBuilder builder) {
        Optional<String> maybeHostnameVerifier;
        Optional<String> maybeKeyStore;
        Optional<String> maybeTrustStore;
        Optional<Boolean> trustAll = this.getOptionalProperty(TLS_TRUST_ALL, Boolean.class);
        if (trustAll.isPresent() && trustAll.get().booleanValue()) {
            this.registerHostnameVerifier(REST_NOOP_HOSTNAME_VERIFIER, builder);
        }
        if ((maybeTrustStore = this.getOptionalDynamicProperty(REST_TRUST_STORE, String.class)).isPresent()) {
            this.registerTrustStore(maybeTrustStore.get(), builder);
        }
        if ((maybeKeyStore = this.getOptionalDynamicProperty(REST_KEY_STORE, String.class)).isPresent()) {
            this.registerKeyStore(maybeKeyStore.get(), builder);
        }
        if ((maybeHostnameVerifier = this.getOptionalDynamicProperty(REST_HOSTNAME_VERIFIER, String.class)).isPresent()) {
            this.registerHostnameVerifier(maybeHostnameVerifier.get(), builder);
        }
    }

    private void registerHostnameVerifier(String verifier, RestClientBuilder builder) {
        try {
            Class<?> verifierClass = Thread.currentThread().getContextClassLoader().loadClass(verifier);
            builder.hostnameVerifier((HostnameVerifier)verifierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find a public, no-argument constructor for the hostname verifier class " + verifier, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find hostname verifier class " + verifier, e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate hostname verifier class " + verifier + ". Make sure it has a public, no-argument constructor", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The provided hostname verifier " + verifier + " is not an instance of HostnameVerifier", e);
        }
    }

    private void registerKeyStore(String keyStorePath, RestClientBuilder builder) {
        Optional<String> keyStorePassword = this.getOptionalDynamicProperty(REST_KEY_STORE_PASSWORD, String.class);
        Optional<String> keyStoreType = this.getOptionalDynamicProperty(REST_KEY_STORE_TYPE, String.class);
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType.orElse("JKS"));
            if (!keyStorePassword.isPresent()) {
                throw new IllegalArgumentException("No password provided for keystore");
            }
            String password = keyStorePassword.get();
            try (InputStream input = this.locateStream(keyStorePath);){
                keyStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + keyStorePath, e);
            }
            builder.keyStore(keyStore, password);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + keyStorePath, e);
        }
    }

    private void registerTrustStore(String trustStorePath, RestClientBuilder builder) {
        Optional<String> maybeTrustStorePassword = this.getOptionalDynamicProperty(REST_TRUST_STORE_PASSWORD, String.class);
        Optional<String> maybeTrustStoreType = this.getOptionalDynamicProperty(REST_TRUST_STORE_TYPE, String.class);
        try {
            KeyStore trustStore = KeyStore.getInstance(maybeTrustStoreType.orElse("JKS"));
            if (!maybeTrustStorePassword.isPresent()) {
                throw new IllegalArgumentException("No password provided for truststore");
            }
            String password = maybeTrustStorePassword.get();
            try (InputStream input = this.locateStream(trustStorePath);){
                trustStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + trustStorePath, e);
            }
            builder.trustStore(trustStore);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + trustStorePath, e);
        }
    }

    private InputStream locateStream(String path) throws FileNotFoundException {
        File certificateFile;
        if (path.startsWith("classpath:")) {
            path = path.replaceFirst("classpath:", "");
            InputStream resultStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            if (resultStream == null) {
                resultStream = this.getClass().getResourceAsStream(path);
            }
            if (resultStream == null) {
                throw new IllegalArgumentException("Classpath resource " + path + " not found for MicroProfile Rest Client SSL configuration");
            }
            return resultStream;
        }
        if (path.startsWith("file:")) {
            path = path.replaceFirst("file:", "");
        }
        if (!(certificateFile = new File(path)).isFile()) {
            throw new IllegalArgumentException("Certificate file: " + path + " not found for MicroProfile Rest Client SSL configuration");
        }
        return new FileInputStream(certificateFile);
    }

    private void configureProviders(RestClientBuilder builder) {
        Optional<String> maybeProviders = this.getOptionalDynamicProperty(REST_PROVIDERS, String.class);
        if (maybeProviders.isPresent()) {
            this.registerProviders(builder, maybeProviders.get());
        }
    }

    private void registerProviders(RestClientBuilder builder, String providersAsString) {
        for (String s : providersAsString.split(",")) {
            builder.register(this.providerClassForName(s.trim()));
        }
    }

    private Class<?> providerClassForName(String name) {
        try {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find provider class: " + name);
        }
    }

    private void configureTimeouts(RestClientBuilder builder) {
        Optional<Long> readTimeout;
        Optional<Long> connectTimeout = this.getOptionalDynamicProperty(REST_CONNECT_TIMEOUT_FORMAT, Long.class);
        if (connectTimeout.isPresent()) {
            builder.connectTimeout(connectTimeout.get().longValue(), TimeUnit.MILLISECONDS);
        }
        if ((readTimeout = this.getOptionalDynamicProperty(REST_READ_TIMEOUT_FORMAT, Long.class)).isPresent()) {
            builder.readTimeout(readTimeout.get().longValue(), TimeUnit.MILLISECONDS);
        }
    }

    private void configureBaseUrl(RestClientBuilder builder) {
        Optional<String> propertyOptional = this.getOptionalDynamicProperty(REST_URI_FORMAT, String.class);
        if (!propertyOptional.isPresent()) {
            propertyOptional = this.getOptionalDynamicProperty(REST_URL_FORMAT, String.class);
        }
        if ((this.baseUriFromAnnotation == null || this.baseUriFromAnnotation.isEmpty()) && !propertyOptional.isPresent()) {
            throw new IllegalArgumentException(String.format("Unable to determine the proper baseUrl/baseUri. Consider registering using @RegisterRestClient(baseUri=\"someuri\"), @RegisterRestClient(configKey=\"orkey\"), or by adding '%s' or '%s' to your Quarkus configuration", String.format(REST_URL_FORMAT, this.propertyPrefix), String.format(REST_URI_FORMAT, this.propertyPrefix)));
        }
        String baseUrl = propertyOptional.orElse(this.baseUriFromAnnotation);
        try {
            builder.baseUrl(new URL(baseUrl));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The value of URL was invalid " + baseUrl, e);
        }
        catch (Exception e) {
            if ("com.oracle.svm.core.jdk.UnsupportedFeatureError".equals(e.getClass().getCanonicalName())) {
                throw new IllegalArgumentException(baseUrl + " requires SSL support but it is disabled. You probably have set quarkus.ssl.native to false.");
            }
            throw e;
        }
    }

    private <T> Optional<T> getOptionalDynamicProperty(String propertyFormat, Class<T> type) {
        Config config = ConfigProvider.getConfig();
        Optional interfaceNameValue = config.getOptionalValue(String.format(propertyFormat, this.jaxrsInterface.getName()), type);
        return interfaceNameValue.isPresent() ? interfaceNameValue : config.getOptionalValue(String.format(propertyFormat, this.propertyPrefix), type);
    }

    private <T> Optional<T> getOptionalProperty(String propertyName, Class<T> type) {
        Config config = ConfigProvider.getConfig();
        return config.getOptionalValue(propertyName, type);
    }
}

