/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.rest.client.reactive.runtime.RestClientCDIDelegateBuilder;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.PreDestroy;
import org.jboss.logging.Logger;

public abstract class RestClientReactiveCDIWrapperBase<T extends Closeable>
implements Closeable {
    private static final Logger log = Logger.getLogger(RestClientReactiveCDIWrapperBase.class);
    private final T delegate;

    public RestClientReactiveCDIWrapperBase(Class<T> jaxrsInterface, String baseUriFromAnnotation, String propertyPrefix) {
        this.delegate = (Closeable)RestClientCDIDelegateBuilder.createDelegate(jaxrsInterface, baseUriFromAnnotation, propertyPrefix);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @PreDestroy
    public void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
            log.warn((Object)"Failed to close cdi-created rest client instance", (Throwable)e);
        }
    }

    public Object getDelegate() {
        return this.delegate;
    }
}

