/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.runtime.hal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.quarkus.rest.data.panache.runtime.hal.HalCollectionWrapper;
import io.quarkus.rest.data.panache.runtime.hal.HalEntityWrapper;
import io.quarkus.rest.data.panache.runtime.hal.HalLink;
import io.quarkus.rest.data.panache.runtime.hal.HalLinksProvider;
import io.quarkus.rest.data.panache.runtime.hal.RestEasyHalLinksProvider;
import java.io.IOException;
import java.util.Map;

public class HalCollectionWrapperJacksonSerializer
extends JsonSerializer<HalCollectionWrapper> {
    private final HalLinksProvider linksExtractor;

    public HalCollectionWrapperJacksonSerializer() {
        this.linksExtractor = new RestEasyHalLinksProvider();
    }

    HalCollectionWrapperJacksonSerializer(HalLinksProvider linksExtractor) {
        this.linksExtractor = linksExtractor;
    }

    public void serialize(HalCollectionWrapper wrapper, JsonGenerator generator, SerializerProvider serializers) throws IOException {
        generator.writeStartObject();
        this.writeEmbedded(wrapper, generator, serializers);
        this.writeLinks(wrapper, generator);
        generator.writeEndObject();
    }

    private void writeEmbedded(HalCollectionWrapper wrapper, JsonGenerator generator, SerializerProvider serializers) throws IOException {
        JsonSerializer entitySerializer = serializers.findValueSerializer(HalEntityWrapper.class);
        generator.writeFieldName("_embedded");
        generator.writeStartObject();
        generator.writeFieldName(wrapper.getCollectionName());
        generator.writeStartArray(wrapper.getCollection().size());
        for (Object entity : wrapper.getCollection()) {
            entitySerializer.serialize((Object)new HalEntityWrapper(entity), generator, serializers);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    private void writeLinks(HalCollectionWrapper wrapper, JsonGenerator generator) throws IOException {
        Map<String, HalLink> links = this.linksExtractor.getLinks(wrapper.getElementType());
        links.putAll(wrapper.getLinks());
        generator.writeFieldName("_links");
        generator.writeObject(links);
    }
}

