/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.runtime.resource;

import io.quarkus.rest.data.panache.runtime.resource.ResourceLinksProvider;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.links.LinksProvider;
import org.jboss.resteasy.links.RESTServiceDiscovery;

public final class RESTEasyClassicResourceLinksProvider
implements ResourceLinksProvider {
    private static final String SELF_REF = "self";

    @Override
    public Map<String, String> getClassLinks(Class<?> className) {
        RESTServiceDiscovery links = LinksProvider.getClassLinksProvider().getLinks(className, Thread.currentThread().getContextClassLoader());
        return this.linksToMap(links);
    }

    @Override
    public Map<String, String> getInstanceLinks(Object instance) {
        RESTServiceDiscovery links = LinksProvider.getObjectLinksProvider().getLinks(instance, Thread.currentThread().getContextClassLoader());
        return this.linksToMap(links);
    }

    @Override
    public String getSelfLink(Object instance) {
        RESTServiceDiscovery.AtomLink link = LinksProvider.getObjectLinksProvider().getLinks(instance, Thread.currentThread().getContextClassLoader()).getLinkForRel(SELF_REF);
        return link == null ? null : link.getHref();
    }

    private Map<String, String> linksToMap(RESTServiceDiscovery serviceDiscovery) {
        HashMap<String, String> links = new HashMap<String, String>(serviceDiscovery.size());
        for (RESTServiceDiscovery.AtomLink atomLink : serviceDiscovery) {
            links.put(atomLink.getRel(), atomLink.getHref());
        }
        return links;
    }
}

