/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.runtime.resource;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.rest.data.panache.runtime.resource.ResourceLinksProvider;
import io.quarkus.resteasy.reactive.links.RestLinksProvider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Link;

public class RESTEasyReactiveResourceLinksProvider
implements ResourceLinksProvider {
    private static final String SELF_REF = "self";

    @Override
    public Map<String, String> getClassLinks(Class<?> className) {
        return this.linksToMap(this.restLinksProvider().getTypeLinks(className));
    }

    @Override
    public Map<String, String> getInstanceLinks(Object instance) {
        return this.linksToMap(this.restLinksProvider().getInstanceLinks(instance));
    }

    @Override
    public String getSelfLink(Object instance) {
        Collection links = this.restLinksProvider().getInstanceLinks(instance);
        for (Link link : links) {
            if (!SELF_REF.equals(link.getRel())) continue;
            return link.getUri().toString();
        }
        return null;
    }

    private RestLinksProvider restLinksProvider() {
        InstanceHandle instance = Arc.container().instance(RestLinksProvider.class, new Annotation[0]);
        if (instance.isAvailable()) {
            return (RestLinksProvider)instance.get();
        }
        throw new IllegalStateException("Invalid use of '" + this.getClass().getName() + "'. No request scope bean found for type '" + RESTEasyReactiveResourceLinksProvider.class.getName() + "'");
    }

    private Map<String, String> linksToMap(Collection<Link> links) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Link link : links) {
            result.put(link.getRel(), link.getUri().toString());
        }
        return result;
    }
}

