/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.client.test;

import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.test.common.http.TestHTTPResource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.client.ClientBuilder;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class ContentTypeHeaderTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{SomeClient.class, Endpoint.class}));
    @TestHTTPResource(value="/foo")
    URI uri;

    ContentTypeHeaderTest() {
    }

    @Test
    void shouldUseDefaultContentType() {
        ClientImpl client = (ClientImpl)ClientBuilder.newClient();
        WebTargetImpl target = (WebTargetImpl)client.target(this.uri);
        SomeClient someClient = (SomeClient)target.proxy(SomeClient.class);
        Assertions.assertThat((String)someClient.postDefaultType("some-text")).isEqualToIgnoringCase((CharSequence)"application/octet-stream");
    }

    @Test
    void shouldUseSpecifiedContentType() {
        ClientImpl client = (ClientImpl)ClientBuilder.newClient();
        WebTargetImpl target = (WebTargetImpl)client.target(this.uri);
        SomeClient someClient = (SomeClient)target.proxy(SomeClient.class);
        Assertions.assertThat((String)someClient.postHtml("some-text")).isEqualToIgnoringCase((CharSequence)"text/html");
    }

    @Test
    void shouldPassTextEntity() {
        ClientImpl client = (ClientImpl)ClientBuilder.newClient();
        WebTargetImpl target = (WebTargetImpl)client.target(this.uri);
        SomeClient someClient = (SomeClient)target.proxy(SomeClient.class);
        Assertions.assertThat((String)someClient.echoText("some-other-text")).isEqualToIgnoringCase((CharSequence)"some-other-text");
    }

    @Path(value="/")
    static interface SomeClient {
        @POST
        public String postDefaultType(String var1);

        @POST
        @Path(value="/as-html")
        @Consumes(value={"text/html"})
        public String postHtml(String var1);

        @POST
        @Consumes(value={"text/plain"})
        @Path(value="/echo")
        public String echoText(String var1);
    }

    @Path(value="/foo")
    static class Endpoint {
        Endpoint() {
        }

        @POST
        @Consumes(value={"*/*"})
        public String postDefaultType(String content, @HeaderParam(value="Content-Type") String contentType) {
            return contentType;
        }

        @POST
        @Consumes(value={"text/plain"})
        @Path(value="/echo")
        public String echoText(String content) {
            return content;
        }

        @POST
        @Path(value="/as-html")
        @Consumes(value={"*/*"})
        public String postHtml(String content, @HeaderParam(value="Content-Type") String contentType) {
            return contentType;
        }
    }
}

