/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.resteasy.reactive.server.Closer;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CloserTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{PerRequestResource.class, SingletonResource.class, CounterResource.class, Counter.class});
        }
    }).overrideRuntimeConfigKey("quarkus.thread-pool.max-threads", "1").overrideRuntimeConfigKey("quarkus.vertx.event-loops-pool-size", "1");

    @Test
    public void test() {
        ((ValidatableResponse)RestAssured.get((String)"/counter/singleton", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/counter/uni-singleton", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/counter/per-request", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/singleton", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/singleton", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"1"), new Matcher[0]);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> ((ValidatableResponse)RestAssured.get((String)"/counter/singleton", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"2"), new Matcher[0]));
        ((ValidatableResponse)RestAssured.get((String)"/counter/uni-singleton", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/counter/per-request", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/uni-singleton", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/uni-singleton", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"1"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/counter/singleton", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"2"), new Matcher[0]);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> ((ValidatableResponse)RestAssured.get((String)"/counter/uni-singleton", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"2"), new Matcher[0]));
        ((ValidatableResponse)RestAssured.get((String)"/counter/per-request", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/per-request", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/per-request", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"1"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/counter/singleton", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"2"), new Matcher[0]);
        ((ValidatableResponse)RestAssured.get((String)"/counter/uni-singleton", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"2"), new Matcher[0]);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> ((ValidatableResponse)RestAssured.get((String)"/counter/per-request", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"2"), new Matcher[0]));
    }

    @Singleton
    public static class Counter {
        public final AtomicInteger perRequest = new AtomicInteger(0);
        public final AtomicInteger singleton = new AtomicInteger(0);
        public final AtomicInteger uniSingleton = new AtomicInteger(0);
    }

    @Path(value="counter")
    public static class CounterResource {
        private final Counter counter;

        public CounterResource(Counter counter) {
            this.counter = counter;
        }

        @Path(value="singleton")
        @GET
        public int singletonCount() {
            return this.counter.singleton.get();
        }

        @Path(value="uni-singleton")
        @GET
        public int uniSingleton() {
            return this.counter.uniSingleton.get();
        }

        @Path(value="per-request")
        @GET
        public int perRequestCount() {
            return this.counter.perRequest.get();
        }
    }

    @Path(value="uni-singleton")
    public static class UniSingletonResource
    implements Closeable {
        @Inject
        Counter counter;
        @Inject
        Closer closer;

        public UniSingletonResource(Counter counter) {
            this.counter = counter;
        }

        @GET
        public Uni<Integer> get() {
            return Uni.createFrom().completionStage(() -> CompletableFuture.completedStage(null)).invoke(() -> this.closer.add((Closeable)this)).map(v -> this.counter.uniSingleton.get());
        }

        @Override
        public void close() {
            this.counter.uniSingleton.incrementAndGet();
        }
    }

    @Path(value="singleton")
    public static class SingletonResource
    implements Closeable {
        private final Counter counter;

        public SingletonResource(Counter counter) {
            this.counter = counter;
        }

        @GET
        public int get(@Context Closer closer) {
            closer.add((Closeable)this);
            return this.counter.singleton.get();
        }

        @Override
        public void close() {
            this.counter.singleton.incrementAndGet();
        }
    }

    @Path(value="per-request")
    @RequestScoped
    public static class PerRequestResource
    implements Closeable {
        private final Closer closer;
        private final Counter counter;

        public PerRequestResource(Closer closer, Counter counter) {
            this.closer = closer;
            this.counter = counter;
        }

        @GET
        public int get() {
            this.closer.add((Closeable)this);
            return this.counter.perRequest.get();
        }

        @Override
        public void close() throws IOException {
            this.counter.perRequest.incrementAndGet();
        }
    }
}

