/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test;

import io.quarkus.resteasy.reactive.server.EndpointDisabled;
import io.quarkus.resteasy.reactive.server.test.multipart.InvalidEncodingTest;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class EndpointDisabledTest {
    @RegisterExtension
    static QuarkusUnitTest TEST = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)jar.addClasses(new Class[]{InvalidEncodingTest.FeedbackBody.class, InvalidEncodingTest.FeedbackResource.class})).addAsResource((Asset)new StringAsset("dummy.disabled=true"), "application.properties"));

    @Test
    public void endpointWithNoAnnotation() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/no-annotation", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"no"), new Matcher[0]);
    }

    @Test
    public void shouldBeDisabledBecauseOfMatchingProperty() {
        ((ValidatableResponse)RestAssured.get((String)"/dummy-disabled-true", (Object[])new Object[0]).then()).statusCode(404);
    }

    @Test
    public void shouldBeEnabledBecauseOfNonMatchingProperty() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/dummy-disabled-false", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"dummy.disabled=false"), new Matcher[0]);
    }

    @Test
    public void shouldBeDisabledBecauseOfNonExistingProperty() {
        ((ValidatableResponse)RestAssured.get((String)"/other-dummy-disabled-missing-true", (Object[])new Object[0]).then()).statusCode(404);
    }

    @Test
    public void shouldBeEnabledBecauseOfNonExistingProperty() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/other-dummy-disabled-missing-false", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"missing=false"), new Matcher[0]);
    }

    @Path(value="other-dummy-disabled-missing-false")
    @EndpointDisabled(name="other.dummy.disabled", stringValue="true", disableIfMissing=false)
    public static class OtherDummyDisabledMissingFalse {
        @GET
        public String get() {
            return "missing=false";
        }
    }

    @Path(value="other-dummy-disabled-missing-true")
    @EndpointDisabled(name="other.dummy.disabled", stringValue="true", disableIfMissing=true)
    public static class OtherDummyDisabledMissingTrue {
        @GET
        public String get() {
            return "missing=true";
        }
    }

    @Path(value="dummy-disabled-false")
    @EndpointDisabled(name="dummy.disabled", stringValue="false", disableIfMissing=false)
    public static class DummyDisabledFalse {
        @GET
        public String get() {
            return "dummy.disabled=false";
        }
    }

    @Path(value="dummy-disabled-true")
    @EndpointDisabled(name="dummy.disabled", stringValue="true", disableIfMissing=false)
    public static class DummyDisabledTrue {
        @GET
        public String get() {
            return "dummy.disabled=true";
        }
    }

    @Path(value="no-annotation")
    public static class NoAnnotation {
        @GET
        public String get() {
            return "no";
        }
    }
}

