/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.beanparam;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class NestedBeanParamInSubResourcesTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestResource.class, SearchResource.class, City.class, Country.class}));

    @Test
    void shouldParseNestedBeanParams() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/city/search?name=Malaga&country=Spain", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Got: Malaga, Spain"), new Matcher[0]);
    }

    @Path(value="/test")
    public static class TestResource {
        @Path(value="/city")
        public SearchResource searchCities() {
            return new SearchResource();
        }
    }

    public static class SearchResource {
        @GET
        @Path(value="/search")
        @Produces(value={"text/plain"})
        public String search(@BeanParam City city) {
            return "Got: " + city.name + ", " + city.country.country;
        }
    }

    public static class City {
        @QueryParam(value="name")
        String name;
        @BeanParam
        Country country;
    }

    public static class Country {
        @QueryParam(value="country")
        String country;
    }
}

