/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.cache;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.Cache;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CacheOnMethodsTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ResourceWithCache.class});
        }
    });

    @Test
    public void testWith() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/with", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"with"), new Matcher[0])).header("Cache-Control", "must-revalidate, no-store, max-age=100, private");
    }

    @Test
    public void testWithout() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/without", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"without"), new Matcher[0])).header("Cache-Control", Matchers.nullValue());
    }

    @Path(value="test")
    public static class ResourceWithCache {
        @Path(value="with")
        @GET
        @Cache(maxAge=100, noStore=true, mustRevalidate=true, isPrivate=true)
        public String with() {
            return "with";
        }

        @Path(value="without")
        @GET
        public String without() {
            return "without";
        }
    }
}

