/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.cache;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.NoCache;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class NoCacheOnMethodsTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ResourceWithNoCache.class});
        }
    });

    @Test
    public void testWithFields() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/withFields", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"withFields"), new Matcher[0])).header("Cache-Control", "no-cache=\"f1\", no-cache=\"f2\"");
    }

    @Test
    public void testWithoutFields() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/withoutFields", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"withoutFields"), new Matcher[0])).header("Cache-Control", "no-cache");
    }

    @Test
    public void testWithoutAnnotation() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/withoutAnnotation", (Object[])new Object[0]).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"withoutAnnotation"), new Matcher[0])).header("Cache-Control", Matchers.nullValue());
    }

    @Path(value="test")
    public static class ResourceWithNoCache {
        @Path(value="withFields")
        @GET
        @NoCache(fields={"f1", "f2"})
        public String withFields() {
            return "withFields";
        }

        @Path(value="withoutFields")
        @GET
        @NoCache
        public String withoutFields() {
            return "withoutFields";
        }

        @Path(value="withoutAnnotation")
        @GET
        public String withoutAnnotation() {
            return "withoutAnnotation";
        }
    }
}

