/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customexceptions;

import io.quarkus.resteasy.reactive.server.test.ExceptionUtil;
import io.quarkus.resteasy.reactive.server.test.customexceptions.MyException;
import io.quarkus.resteasy.reactive.server.test.customexceptions.MyOtherException;
import io.quarkus.resteasy.reactive.server.test.customexceptions.UniException;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpServerRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.jboss.resteasy.reactive.RestQuery;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;

@Path(value="first")
public class FirstResource {
    @GET
    @Produces(value={"text/plain"})
    public String throwsVariousExceptions(@RestQuery String name) {
        if (name.startsWith("IllegalArgument")) {
            throw ExceptionUtil.removeStackTrace(new IllegalArgumentException());
        }
        if (name.startsWith("IllegalState")) {
            throw ExceptionUtil.removeStackTrace(new IllegalStateException("IllegalState"));
        }
        if (name.startsWith("MyOther")) {
            throw ExceptionUtil.removeStackTrace(new MyOtherException());
        }
        if (name.startsWith("My")) {
            throw ExceptionUtil.removeStackTrace(new MyException());
        }
        if (name.startsWith("Uni")) {
            throw ExceptionUtil.removeStackTrace(new UniException());
        }
        throw ExceptionUtil.removeStackTrace(new RuntimeException());
    }

    @GET
    @Path(value="uni")
    @Produces(value={"text/plain"})
    public Uni<String> uni(@RestQuery String name) {
        RuntimeException e = new RuntimeException();
        if (name.startsWith("IllegalArgument")) {
            e = new IllegalArgumentException();
        } else if (name.startsWith("IllegalState")) {
            e = new IllegalStateException("IllegalState");
        } else if (name.startsWith("MyOther")) {
            e = new MyOtherException();
        } else if (name.startsWith("My")) {
            e = new MyException();
        } else if (name.startsWith("Uni")) {
            e = new UniException();
        }
        return Uni.createFrom().failure((Throwable)ExceptionUtil.removeStackTrace(e));
    }

    @ServerExceptionMapper(value={IllegalStateException.class, IllegalArgumentException.class})
    public Response handleIllegal(Exception e) {
        return Response.status((int)409).entity((Object)e.getMessage()).build();
    }

    @ServerExceptionMapper
    public Response handleMyException(SimpleResourceInfo simplifiedResourceInfo, MyException myException, ContainerRequestContext containerRequestContext, UriInfo uriInfo, HttpHeaders httpHeaders, Request request, HttpServerRequest httpServerRequest) {
        return Response.status((int)410).entity((Object)(uriInfo.getPath() + "->" + simplifiedResourceInfo.getMethodName())).build();
    }

    @ServerExceptionMapper(value={UniException.class})
    public Uni<Response> handleUniException(UniException e, UriInfo uriInfo, SimpleResourceInfo simplifiedResourceInfo) {
        return Uni.createFrom().item(() -> Response.status((int)412).entity((Object)(uriInfo.getPath() + "->" + simplifiedResourceInfo.getMethodName())).build());
    }
}

