/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customexceptions;

import io.quarkus.resteasy.reactive.server.test.ExceptionUtil;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ImplClassExceptionMapperTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{CustomResourceImpl.class, CustomResource.class, GlobalCustomResourceImpl.class, GlobalCustomResource.class, DefaultCustomResource.class, ExceptionUtil.class});
        }
    });

    @Test
    public void test() {
        ((ValidatableResponse)RestAssured.get((String)"/custom/error", (Object[])new Object[0]).then()).statusCode(416);
        ((ValidatableResponse)RestAssured.get((String)"/stock/error", (Object[])new Object[0]).then()).statusCode(500);
        ((ValidatableResponse)RestAssured.get((String)"/default/error", (Object[])new Object[0]).then()).statusCode(417);
    }

    @Path(value="stock")
    public static interface GlobalCustomResource {
        @GET
        @Path(value="error")
        @Produces(value={"text/plain"})
        public String throwsException();
    }

    public static class GlobalCustomResourceImpl
    implements GlobalCustomResource {
        @Override
        public String throwsException() {
            throw ExceptionUtil.removeStackTrace(new RuntimeException());
        }
    }

    @Path(value="custom")
    public static interface CustomResource {
        @GET
        @Path(value="error")
        @Produces(value={"text/plain"})
        public String throwsException();
    }

    public static class CustomResourceImpl
    implements CustomResource {
        @ServerExceptionMapper
        public Response handleThrowable(RuntimeException t) {
            return Response.status((int)416).build();
        }

        @Override
        public String throwsException() {
            throw ExceptionUtil.removeStackTrace(new RuntimeException());
        }
    }

    @Path(value="default")
    public static class DefaultCustomResource {
        @ServerExceptionMapper
        public Response handleThrowable(RuntimeException t) {
            return Response.status((int)417).build();
        }

        @GET
        @Path(value="error")
        @Produces(value={"text/plain"})
        public String throwsException() {
            throw ExceptionUtil.removeStackTrace(new RuntimeException());
        }
    }
}

