/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customexceptions;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.annotation.security.DenyAll;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class SecurityExceptionMapperWithResourceInfoTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Resource.class});
        }
    });

    @Test
    void test() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/denied", (Object[])new Object[0]).then()).statusCode(403)).body(Matchers.is((Object)Resource.class.getName()), new Matcher[0]);
    }

    @Path(value="test")
    public static class Resource {
        @GET
        @Path(value="denied")
        @Produces(value={"text/plain"})
        @DenyAll
        public String denied() {
            return "denied";
        }

        @ServerExceptionMapper(value={SecurityException.class})
        Response handle(SecurityException t, ResourceInfo resourceInfo) {
            return Response.status((int)403).entity((Object)resourceInfo.getResourceClass().getName()).build();
        }
    }
}

