/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customexceptions;

import io.quarkus.arc.ArcUndeclaredThrowableException;
import io.quarkus.resteasy.reactive.server.test.ExceptionUtil;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class UnwrappedExceptionTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ExceptionResource.class, ExceptionMappers.class, ExceptionUtil.class});
        }
    });

    @Test
    public void testWrapperWithUnmappedException() {
        ((ValidatableResponse)RestAssured.get((String)"/hello/wrapperOfIAE", (Object[])new Object[0]).then()).statusCode(500);
    }

    @Test
    public void testWrapperWithMappedException() {
        ((ValidatableResponse)RestAssured.get((String)"/hello/wrapperOfISE", (Object[])new Object[0]).then()).statusCode(999);
    }

    @Test
    public void testUnmappedException() {
        ((ValidatableResponse)RestAssured.get((String)"/hello/iae", (Object[])new Object[0]).then()).statusCode(500);
    }

    @Test
    public void testMappedException() {
        ((ValidatableResponse)RestAssured.get((String)"/hello/ise", (Object[])new Object[0]).then()).statusCode(999);
    }

    public static class ExceptionMappers {
        @ServerExceptionMapper
        Response mapISE(IllegalStateException e) {
            return Response.status((int)999).build();
        }
    }

    @Path(value="hello")
    public static class ExceptionResource {
        @Path(value="wrapperOfIAE")
        public String wrapperOfIAE() {
            throw ExceptionUtil.removeStackTrace(new ArcUndeclaredThrowableException((Throwable)ExceptionUtil.removeStackTrace(new IllegalArgumentException())));
        }

        @Path(value="wrapperOfISE")
        public String wrapperOfISE() {
            throw ExceptionUtil.removeStackTrace(new ArcUndeclaredThrowableException((Throwable)ExceptionUtil.removeStackTrace(new IllegalStateException())));
        }

        @Path(value="iae")
        public String iae() {
            throw ExceptionUtil.removeStackTrace(new IllegalArgumentException());
        }

        @Path(value="ise")
        public String ise() {
            throw ExceptionUtil.removeStackTrace(new IllegalStateException());
        }
    }
}

