/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customproviders;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.List;
import java.util.function.Supplier;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class PreMatchingHeadersFilterTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Resource.class});
        }
    });

    @Test
    public void testJsonHeaderAdded() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"foo\": \"bar\"}").when().post("/test", new Object[0])).then()).statusCode(200)).body("foo", Matchers.equalTo((Object)"bar"), new Object[0]);
    }

    public static class Filters {
        @ServerRequestFilter(preMatching=true)
        public void preMatchingFilter(ContainerRequestContext requestContext) {
            requestContext.getHeaders().put((Object)"Content-Type", List.of("application/json"));
        }
    }

    @Path(value="test")
    public static class Resource {
        @POST
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        public String post(String json) {
            return json;
        }
    }
}

