/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.customproviders;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.RestForm;
import org.jboss.resteasy.reactive.server.WithFormRead;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class WithFormBodyTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{HelloResource.class});
        }
    });

    @Test
    public void testMethodWithBody() {
        ((ValidatableResponse)((Response)RestAssured.with().formParam("name", new Object[]{"Quarkus"}).post("/hello", new Object[0])).then()).body(Matchers.equalTo((Object)"hello Quarkus"), new Matcher[0]);
    }

    @Test
    public void testMethodWithUndeclaredBody() {
        ((ValidatableResponse)((Response)RestAssured.with().formParam("name", new Object[]{"Quarkus"}).post("/hello/empty", new Object[0])).then()).body(Matchers.equalTo((Object)"hello Quarkus"), new Matcher[0]);
    }

    @Path(value="hello")
    public static class HelloResource {
        @POST
        public String helloPost(@RestForm String name) {
            return "hello " + name;
        }

        @WithFormRead
        @Path(value="empty")
        @POST
        public String helloEmptyPost(ServerRequestContext requestContext) {
            return "hello " + ((ResteasyReactiveRequestContext)requestContext).getFormParameter("name", true, false);
        }
    }
}

