/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.builder.MultiPartSpecBuilder;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.MultiPartSpecification;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.resteasy.reactive.RestForm;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class InvalidEncodingTest {
    private static final String TEXT_WITH_ACCENTED_CHARACTERS = "Text with UTF-8 accented characters: \u00e9 \u00e0 \u00e8";
    @RegisterExtension
    static QuarkusUnitTest TEST = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)jar.addClasses(new Class[]{FeedbackBody.class, FeedbackResource.class})).addAsResource((Asset)new StringAsset("quarkus.rest.multipart.input-part.default-charset=us-ascii"), "application.properties"));

    @Test
    public void testMultipartEncoding() throws URISyntaxException {
        MultiPartSpecification multiPartSpecification = new MultiPartSpecBuilder(TEXT_WITH_ACCENTED_CHARACTERS).controlName("content").header("Content-Type", "text/plain").charset(StandardCharsets.UTF_8).build();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart(multiPartSpecification).post("/test/multipart-encoding", new Object[0])).then()).statusCode(200)).body(CoreMatchers.not((Object)TEXT_WITH_ACCENTED_CHARACTERS), new Matcher[0]);
    }

    public static class FeedbackBody {
        @RestForm(value="content")
        public String content;
    }

    @Path(value="/test")
    public static class FeedbackResource {
        @POST
        @Path(value="/multipart-encoding")
        @Produces(value={"text/plain"})
        @Consumes(value={"multipart/form-data;charset=UTF-8"})
        public String postForm(@BeanParam FeedbackBody feedback) {
            return feedback.content;
        }
    }
}

