/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.resteasy.reactive.server.test.multipart.MultipartDataInputTest;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.jboss.resteasy.reactive.PartType;
import org.jboss.resteasy.reactive.RestForm;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MultipartBinaryWithoutFilenameTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{MultipartDataInputTest.Resource.class, MultipartDataInputTest.Item.class, MultipartDataInputTest.Result.class});
        }
    });
    private final File IMAGE_FILE = new File("./src/test/resources/image.png");

    @Test
    public void test() throws IOException {
        byte[] bytes = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("multipart/form-data").multiPart("bytes", this.IMAGE_FILE, "application/png").when().post("/test", new Object[0])).then()).statusCode(200)).extract().body().asByteArray();
        Assertions.assertThat((byte[])bytes).isEqualTo((Object)Files.readAllBytes(this.IMAGE_FILE.toPath()));
    }

    public static class Input {
        @RestForm(value="bytes")
        @PartType(value="application/octet-stream")
        public byte[] bytes;
    }

    @Path(value="/test")
    public static class Resource {
        @POST
        public byte[] testMultipart(Input input) {
            return input.bytes;
        }
    }
}

