/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.resteasy.reactive.server.test.multipart.AbstractMultipartTest;
import io.quarkus.resteasy.reactive.server.test.multipart.FormData;
import io.quarkus.resteasy.reactive.server.test.multipart.FormDataBase;
import io.quarkus.resteasy.reactive.server.test.multipart.FormDataSameFileName;
import io.quarkus.resteasy.reactive.server.test.multipart.MultipartResource;
import io.quarkus.resteasy.reactive.server.test.multipart.OtherFormData;
import io.quarkus.resteasy.reactive.server.test.multipart.OtherFormDataBase;
import io.quarkus.resteasy.reactive.server.test.multipart.OtherMultipartResource;
import io.quarkus.resteasy.reactive.server.test.multipart.Status;
import io.quarkus.resteasy.reactive.server.test.multipart.other.OtherPackageFormDataBase;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MultipartOptionalInputTest
extends AbstractMultipartTest {
    private static final Path uploadDir = Paths.get("file-uploads", new String[0]);
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{FormDataBase.class, OtherPackageFormDataBase.class, FormData.class, Status.class, OtherFormData.class, FormDataSameFileName.class, OtherFormDataBase.class, MultipartResource.class, OtherMultipartResource.class})).addAsResource((Asset)new StringAsset("quarkus.http.body.delete-uploaded-files-on-end=false\nquarkus.http.body.uploads-directory=" + uploadDir.toString() + "\n"), "application.properties");
        }
    });
    private final File HTML_FILE = new File("./src/test/resources/test.html");

    @BeforeEach
    public void assertEmptyUploads() {
        Assertions.assertTrue((boolean)this.isDirectoryEmpty(uploadDir));
    }

    @AfterEach
    public void clearDirectory() {
        this.clearDirectory(uploadDir);
    }

    @Test
    public void testUploadWithSomeFilesMissing() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().multiPart("name", "Alice").multiPart("active", "true").multiPart("num", "25").multiPart("status", "WORKING").multiPart("htmlFile", this.HTML_FILE, "text/html").accept("text/plain").when().post("/multipart/optional", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"Alice - true - 25 - WORKING - true - false - false"), new Matcher[0]);
        File[] uploadedFiles = uploadDir.toFile().listFiles();
        Assertions.assertNotNull((Object)uploadedFiles);
        Assertions.assertEquals((int)1, (int)uploadedFiles.length);
    }
}

