/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.resteasy.reactive.server.test.multipart.FormDataWithAllUploads;
import io.quarkus.resteasy.reactive.server.test.multipart.Status;
import io.quarkus.runtime.BlockingOperationControl;
import io.smallrye.common.annotation.NonBlocking;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.jboss.resteasy.reactive.PartType;
import org.jboss.resteasy.reactive.RestForm;
import org.jboss.resteasy.reactive.multipart.FileUpload;

@Path(value="/multipart-all")
public class MultipartResourceWithAllUploads {
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    @NonBlocking
    @Path(value="/simple/{times}")
    public String simple(@BeanParam FormDataWithAllUploads formData, Integer times) {
        if (BlockingOperationControl.isBlockingAllowed()) {
            throw new RuntimeException("should not have dispatched");
        }
        FileUpload txtFile = formData.getUploads().stream().filter(f -> f.name().equals("txtFile")).findFirst().get();
        return formData.getName() + " - " + formData.active + " - " + times * formData.getNum() + " - " + formData.getStatus() + " - " + formData.getUploads().size() + " - " + txtFile.contentType();
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"multipart/form-data"})
    @NonBlocking
    @Path(value="/param/simple/{times}")
    public String simple(@RestForm String name, @RestForm @PartType(value="text/plain") Status status, @RestForm(value="*") List<FileUpload> uploads, @RestForm @PartType(value="text/plain") boolean active, @RestForm @PartType(value="text/plain") int num, Integer times) {
        if (BlockingOperationControl.isBlockingAllowed()) {
            throw new RuntimeException("should not have dispatched");
        }
        FileUpload txtFile = uploads.stream().filter(f -> f.name().equals("txtFile")).findFirst().get();
        return name + " - " + active + " - " + times * num + " - " + status + " - " + uploads.size() + " - " + txtFile.contentType();
    }
}

