/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jboss.resteasy.reactive.multipart.FileDownload;

public class PathFileDownload
implements FileDownload {
    private final String partName;
    private final File file;

    public PathFileDownload(File file) {
        this(null, file);
    }

    public PathFileDownload(String partName, File file) {
        this.partName = partName;
        this.file = file;
    }

    public String name() {
        return this.partName;
    }

    public Path filePath() {
        return this.file.toPath();
    }

    public String fileName() {
        return this.file.getName();
    }

    public long size() {
        try {
            return Files.size(this.file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get size", e);
        }
    }

    public String contentType() {
        return null;
    }

    public String charSet() {
        return null;
    }
}

