/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.multipart;

import io.quarkus.resteasy.reactive.server.test.multipart.AbstractMultipartTest;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class PathInputWithoutDeleteTest
extends AbstractMultipartTest {
    private static final java.nio.file.Path uploadDir = Paths.get("file-uploads", new String[0]);
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Resource.class})).addAsResource((Asset)new StringAsset("quarkus.http.body.delete-uploaded-files-on-end=false\nquarkus.http.body.uploads-directory=" + uploadDir.toString() + "\n"), "application.properties");
        }
    });
    private final File HTML_FILE = new File("./src/test/resources/test.html");
    private final File HTML_FILE2 = new File("./src/test/resources/test2.html");

    @BeforeEach
    public void assertEmptyUploads() {
        Assertions.assertTrue((boolean)this.isDirectoryEmpty(uploadDir));
    }

    @AfterEach
    public void clearDirectory() {
        this.clearDirectory(uploadDir);
    }

    @Test
    public void test() throws IOException {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("application/octet-stream").body(this.HTML_FILE).when().post("/test", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)this.fileSizeAsStr(this.HTML_FILE)), new Matcher[0]);
        Assertions.assertEquals((int)1, (int)uploadDir.toFile().listFiles().length);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("application/octet-stream").body(this.HTML_FILE2).when().post("/test", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)this.fileSizeAsStr(this.HTML_FILE2)), new Matcher[0]);
        Assertions.assertEquals((int)2, (int)uploadDir.toFile().listFiles().length);
    }

    @Path(value="test")
    public static class Resource {
        @POST
        @Consumes(value={"application/octet-stream"})
        public long size(java.nio.file.Path file) throws IOException {
            return Files.size(file);
        }
    }
}

