/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.providers;

import io.smallrye.mutiny.Uni;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.OpenOptions;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.core.Vertx;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.io.File;
import java.nio.file.Paths;
import org.jboss.resteasy.reactive.FilePart;
import org.jboss.resteasy.reactive.PathPart;
import org.jboss.resteasy.reactive.RestResponse;

@Path(value="providers/file")
public class FileResource {
    private static final String FILE = "src/test/resources/lorem.txt";

    @Path(value="file")
    @GET
    public File getFile() {
        return new File(FILE);
    }

    @Path(value="file-partial")
    @GET
    public FilePart getFilePart() {
        return new FilePart(new File(FILE), 20L, 10L);
    }

    @Path(value="path")
    @GET
    public java.nio.file.Path getPath() {
        return Paths.get(FILE, new String[0]);
    }

    @Path(value="path-partial")
    @GET
    public PathPart getPathPart() {
        return new PathPart(Paths.get(FILE, new String[0]), 20L, 10L);
    }

    @Path(value="async-file")
    @GET
    public Uni<AsyncFile> getAsyncFile(RoutingContext vertxRequest) {
        return Uni.createFrom().emitter(emitter -> vertxRequest.vertx().fileSystem().open(FILE, new OpenOptions(), result -> {
            if (result.succeeded()) {
                emitter.complete(result.result());
            } else {
                emitter.fail(result.cause());
            }
        }));
    }

    @Path(value="rest-response-async-file")
    @GET
    public Uni<RestResponse<AsyncFile>> getRestResponseAsyncFile(RoutingContext vertxRequest) {
        return Uni.createFrom().emitter(emitter -> vertxRequest.vertx().fileSystem().open(FILE, new OpenOptions(), result -> {
            if (result.succeeded()) {
                emitter.complete((Object)RestResponse.ResponseBuilder.ok((Object)((AsyncFile)result.result())).header("foo", (Object)"bar").build());
            } else {
                emitter.fail(result.cause());
            }
        }));
    }

    @Path(value="mutiny-async-file")
    @GET
    public Uni<io.vertx.mutiny.core.file.AsyncFile> getMutinyAsyncFile(RoutingContext vertxRequest) {
        return new Vertx(vertxRequest.vertx()).fileSystem().open(FILE, new OpenOptions());
    }

    @Path(value="async-file-partial")
    @GET
    public Uni<AsyncFile> getAsyncFilePartial(RoutingContext vertxRequest) {
        return Uni.createFrom().emitter(emitter -> vertxRequest.vertx().fileSystem().open(FILE, new OpenOptions(), result -> {
            if (result.succeeded()) {
                AsyncFile asyncFile = (AsyncFile)result.result();
                asyncFile.setReadPos(20L);
                asyncFile.setReadLength(10L);
                emitter.complete((Object)asyncFile);
            } else {
                emitter.fail(result.cause());
            }
        }));
    }
}

