/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.providers;

import io.quarkus.resteasy.reactive.server.test.providers.FileResource;
import io.quarkus.resteasy.reactive.server.test.providers.WithWriterInterceptor;
import io.quarkus.resteasy.reactive.server.test.providers.WriterInterceptor;
import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.test.common.http.TestHTTPResource;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.FilePart;
import org.jboss.resteasy.reactive.PathPart;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class FileTestCase {
    private static final String FILE = "src/test/resources/lorem.txt";
    @TestHTTPResource
    URI uri;
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{FileResource.class, WithWriterInterceptor.class, WriterInterceptor.class}));

    @Test
    public void testFiles() throws Exception {
        String content = Files.readString(Path.of(FILE, new String[0]));
        String contentLength = String.valueOf(content.length());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/providers/file/file", (Object[])new Object[0]).then()).statusCode(200)).header("Content-Length", contentLength)).body(Matchers.equalTo((Object)content), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Range", (Object)"bytes=0-9", new Object[0]).get("/providers/file/file", new Object[0])).then()).statusCode(206)).header("Content-Length", "10")).header("Content-Range", "bytes 0-9/" + contentLength)).body(Matchers.equalTo((Object)content.substring(0, 10)), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Range", (Object)"bytes=10-19", new Object[0]).get("/providers/file/file", new Object[0])).then()).statusCode(206)).header("Content-Length", "10")).header("Content-Range", "bytes 10-19/" + contentLength)).body(Matchers.equalTo((Object)content.substring(10, 20)), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Range", (Object)"bytes=10-", new Object[0]).get("/providers/file/file", new Object[0])).then()).statusCode(206)).header("Content-Length", String.valueOf(content.length() - 10))).header("Content-Range", "bytes 10-" + (content.length() - 1) + "/" + contentLength)).body(Matchers.equalTo((Object)content.substring(10)), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Range", (Object)"bytes=-10", new Object[0]).get("/providers/file/file", new Object[0])).then()).statusCode(206)).header("Content-Length", "10")).header("Content-Range", "bytes " + (content.length() - 10) + "-" + (content.length() - 1) + "/" + contentLength)).body(Matchers.equalTo((Object)content.substring(content.length() - 10)), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Range", (Object)("bytes=" + (content.length() + 1) + "-"), new Object[0]).get("/providers/file/file", new Object[0])).then()).statusCode(200)).header("Content-Length", contentLength)).body(Matchers.equalTo((Object)content), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Range", (Object)"bytes=0-1, 3-4", new Object[0]).get("/providers/file/file", new Object[0])).then()).statusCode(200)).header("Content-Length", contentLength)).body(Matchers.equalTo((Object)content), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/providers/file/file-partial", (Object[])new Object[0]).then()).statusCode(200)).header("Content-Length", "10")).body(Matchers.equalTo((Object)content.substring(20, 30)), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/providers/file/path", (Object[])new Object[0]).then()).statusCode(200)).header("Content-Length", contentLength)).body(Matchers.equalTo((Object)content), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/providers/file/path-partial", (Object[])new Object[0]).then()).statusCode(200)).header("Content-Length", "10")).body(Matchers.equalTo((Object)content.substring(20, 30)), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/providers/file/async-file", (Object[])new Object[0]).then()).header("Content-Length", Matchers.nullValue())).statusCode(200)).body(Matchers.equalTo((Object)content), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/providers/file/rest-response-async-file", (Object[])new Object[0]).then()).header("foo", "bar")).statusCode(200)).body(Matchers.equalTo((Object)content), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/providers/file/mutiny-async-file", (Object[])new Object[0]).then()).header("Content-Length", Matchers.nullValue())).statusCode(200)).body(Matchers.equalTo((Object)content), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/providers/file/async-file-partial", (Object[])new Object[0]).then()).statusCode(200)).header("Content-Length", "10")).body(Matchers.equalTo((Object)content.substring(20, 30)), new Matcher[0]);
    }

    @Test
    public void testChecks() throws IOException {
        Path path = Paths.get(FILE, new String[0]);
        new PathPart(path, 10L, 10L);
        new PathPart(path, 0L, Files.size(path));
        try {
            new PathPart(path, -1L, 10L);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PathPart(path, 0L, -1L);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PathPart(path, 0L, 1000L);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PathPart(path, 250L, 250L);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        File file = new File(FILE);
        new FilePart(file, 10L, 10L);
        new FilePart(file, 0L, file.length());
        try {
            new FilePart(file, -1L, 10L);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new FilePart(file, 0L, -1L);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new FilePart(file, 0L, 1000L);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new FilePart(file, 250L, 250L);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

