/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.providers;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ParamConverterTest {
    private static final String STATIC_UUID = "42f425f1-5923-41ca-a43c-713888762c68";
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addClasses(new Class[]{UUIDResource.class, UUIDParamConverterProvider.class}));

    @Test
    public void single() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/uuid/single?id=whatever", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)STATIC_UUID), new Matcher[0]);
    }

    @Test
    public void set() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/uuid/set?id=whatever&id=whatever2", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)STATIC_UUID), new Matcher[0]);
    }

    @Test
    public void list() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/uuid/list?id=whatever&id=whatever2", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"42f425f1-5923-41ca-a43c-713888762c68,42f425f1-5923-41ca-a43c-713888762c68"), new Matcher[0]);
    }

    @Path(value="uuid")
    public static class UUIDResource {
        @Path(value="single")
        @GET
        public String single(@QueryParam(value="id") UUID uuid) {
            return uuid.toString();
        }

        @Path(value="set")
        @GET
        public String set(@QueryParam(value="id") Set<UUID> uuids) {
            return UUIDResource.join(uuids.stream());
        }

        @Path(value="list")
        @GET
        public String list(@QueryParam(value="id") List<? extends UUID> uuids) {
            return UUIDResource.join(uuids.stream());
        }

        private static String join(Stream<? extends UUID> uuids) {
            return uuids.map(UUID::toString).collect(Collectors.joining(","));
        }
    }

    @Provider
    public static class UUIDParamConverterProvider
    implements ParamConverterProvider {
        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            if (rawType.equals(UUID.class)) {
                return new UUIDParamConverter();
            }
            return null;
        }

        public static class UUIDParamConverter
        implements ParamConverter<UUID> {
            public UUID fromString(String value) {
                return UUID.fromString(ParamConverterTest.STATIC_UUID);
            }

            public String toString(UUID value) {
                return value.toString();
            }
        }
    }
}

