/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.providers;

import io.quarkus.runtime.annotations.StaticInitSafe;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.smallrye.config.common.MapBackedConfigSource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.util.Map;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ProviderConfigInjectionTest {
    @RegisterExtension
    static final QuarkusUnitTest TEST = new QuarkusUnitTest().withApplicationRoot(jar -> jar.addAsServiceProvider("org.eclipse.microprofile.config.spi.ConfigSource", new String[]{StaticConfigSource.class.getName(), RuntimeConfigSource.class.getName()}));

    @Test
    public void configInjection() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/test", new Object[0])).then()).body(Matchers.is((Object)"runtime"), new Matcher[0]);
    }

    @StaticInitSafe
    public static class StaticConfigSource
    extends MapBackedConfigSource {
        public StaticConfigSource() {
            super("static", Map.of("configProperty", "static"), 100);
        }
    }

    public static class RuntimeConfigSource
    extends MapBackedConfigSource {
        public RuntimeConfigSource() {
            super("runtime", Map.of("configProperty", "runtime"), 200);
        }
    }

    @Provider
    public static class FooProvider
    implements ContextResolver<String> {
        @ConfigProperty(name="configProperty", defaultValue="configProperty")
        String configProperty;

        public String getContext(Class<?> type) {
            return this.configProperty;
        }
    }

    @Path(value="/test")
    public static class TestResource {
        @Context
        Providers providers;

        @GET
        public String getFoo() {
            return (String)this.providers.getContextResolver(String.class, MediaType.TEXT_PLAIN_TYPE).getContext(null);
        }
    }
}

