/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.common.providers.serialisers.MessageReaderUtil;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class BasicGenericTypesHandlingTest {
    @RegisterExtension
    static QuarkusUnitTest testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            archive.addClasses(new Class[]{AbstractResource.class, TestResource.class, Input.class, Output.class, TestMessageBodyReader.class, TestMessageBodyWriter.class});
            return archive;
        }
    });

    @Test
    public void test() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().body("hello").contentType("text/test").post("/test", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"out / hello"), new Matcher[0]);
    }

    @Provider
    @Produces(value={"text/test"})
    public static class TestMessageBodyWriter
    implements ServerMessageBodyWriter<Object> {
        public boolean isWriteable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo target, MediaType mediaType) {
            return genericType.getTypeName().equals(Output.class.getName());
        }

        public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
            if (!genericType.getTypeName().equals(Output.class.getName())) {
                throw new IllegalStateException("Writer called with generic type: " + genericType.getTypeName());
            }
            context.getOrCreateOutputStream().write(((Output)o).getOutMessage().getBytes(StandardCharsets.UTF_8));
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            throw new IllegalStateException("should never have been called");
        }

        public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            throw new IllegalStateException("should never have been called");
        }
    }

    @Provider
    @Consumes(value={"text/test"})
    public static class TestMessageBodyReader
    implements ServerMessageBodyReader<Object> {
        public boolean isReadable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo lazyMethod, MediaType mediaType) {
            return genericType.getTypeName().equals(Input.class.getName());
        }

        public Object readFrom(Class<Object> type, Type genericType, MediaType mediaType, ServerRequestContext context) throws WebApplicationException, IOException {
            return new Input(MessageReaderUtil.readString((InputStream)context.getInputStream(), (MediaType)mediaType));
        }

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            throw new IllegalStateException("should never have been called");
        }

        public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            throw new IllegalStateException("should never have been called");
        }
    }

    public static class Output {
        private final String outMessage;

        public Output(String outMessage) {
            this.outMessage = outMessage;
        }

        public String getOutMessage() {
            return this.outMessage;
        }
    }

    public static class Input {
        private final String inMessage;

        public Input(String inMessage) {
            this.inMessage = inMessage;
        }

        public String getInMessage() {
            return this.inMessage;
        }
    }

    @Path(value="/test")
    public static class TestResource
    extends AbstractResource<Input, Output> {
        @Override
        protected Output convert(Input input) {
            return new Output("out / " + input.getInMessage());
        }
    }

    public static abstract class AbstractResource<I, O> {
        protected abstract O convert(I var1);

        @POST
        @Produces(value={"text/test"})
        @Consumes(value={"text/test"})
        public O handle(I i) {
            return this.convert(i);
        }
    }
}

