/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.CollectionDefaultValueResource;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Collection Default Value Test")
public class CollectionDefaultValueTest {
    static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    @BeforeEach
    public void init() {
        client = ClientBuilder.newClient();
    }

    @AfterEach
    public void after() throws Exception {
        client.close();
    }

    private String generateURL(String path) {
        return PortProviderUtil.generateURL(path, CollectionDefaultValueTest.class.getSimpleName());
    }

    @Test
    @DisplayName(value="Test Empty")
    public void testEmpty() throws Exception {
        Response response = client.target(this.generateURL("/collection")).request().get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        response.close();
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClasses(new Class[]{CollectionDefaultValueResource.class, PortProviderUtil.class});
                return war;
            }
        });
    }
}

