/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ContainerRequestContextTest {
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(HelloResource.class);
        }
    });

    @Test
    public void helloWorldTest() {
        ((ValidatableResponse)RestAssured.get((String)"/hello", (Object[])new Object[0]).then()).body(Matchers.equalTo((Object)"hello foo"), new Matcher[0]);
    }

    @Provider
    public static class TestFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext context) throws IOException {
            context.setProperty("name", (Object)"foo");
        }
    }

    @Path(value="/hello")
    public static class HelloResource {
        private final ContainerRequestContext containerRequestContext;

        public HelloResource(ContainerRequestContext containerRequestContext) {
            this.containerRequestContext = containerRequestContext;
        }

        @GET
        public String hello() {
            return "hello " + this.containerRequestContext.getProperty("name");
        }
    }
}

