/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.DefaultMediaTypeCustomObject;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.DefaultMediaTypeResource;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Default Media Type Test")
public class DefaultMediaTypeTest {
    private final Logger LOG = Logger.getLogger((String)DefaultMediaTypeResource.class.getName());
    static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    @BeforeEach
    public void init() {
        client = ClientBuilder.newClient();
    }

    @AfterEach
    public void after() throws Exception {
        client.close();
        client = null;
    }

    private String generateURL(String path) {
        return PortProviderUtil.generateURL(path, DefaultMediaTypeResource.class.getSimpleName());
    }

    @Test
    @DisplayName(value="Post Date Produce")
    public void postDateProduce() throws Exception {
        WebTarget target = client.target(this.generateURL("/postDateProduce"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
        for (int i = 0; i < 5000; ++i) {
            baos.write(i);
        }
        Response response = target.request().post(Entity.entity((Object)baos.toByteArray(), (String)"application/octet-stream"));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String responseContent = (String)response.readEntity(String.class);
        this.LOG.debug((Object)String.format("Response: %s", responseContent));
    }

    @Test
    @DisplayName(value="Post Date")
    public void postDate() throws Exception {
        WebTarget target = client.target(this.generateURL("/postDate"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
        for (int i = 0; i < 5000; ++i) {
            baos.write(i);
        }
        Response response = target.request().post(Entity.entity((Object)baos.toByteArray(), (String)"application/octet-stream"));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String responseContent = (String)response.readEntity(String.class);
        this.LOG.debug((Object)String.format("Response: %s", responseContent));
    }

    @Test
    @DisplayName(value="Post Foo Produce")
    public void postFooProduce() throws Exception {
        WebTarget target = client.target(this.generateURL("/postFooProduce"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
        for (int i = 0; i < 5000; ++i) {
            baos.write(i);
        }
        Response response = target.request().post(Entity.entity((Object)baos.toByteArray(), (String)"application/octet-stream"));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String responseContent = (String)response.readEntity(String.class);
        this.LOG.debug((Object)String.format("Response: %s", responseContent));
    }

    @Test
    @DisplayName(value="Post Foo")
    public void postFoo() throws Exception {
        WebTarget target = client.target(this.generateURL("/postFoo"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
        for (int i = 0; i < 5000; ++i) {
            baos.write(i);
        }
        Response response = target.request().post(Entity.entity((Object)baos.toByteArray(), (String)"application/octet-stream"));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String responseContent = (String)response.readEntity(String.class);
        this.LOG.debug((Object)String.format("Response: %s", responseContent));
    }

    @Test
    @DisplayName(value="Post Int Produce")
    public void postIntProduce() throws Exception {
        WebTarget target = client.target(this.generateURL("/postIntProduce"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
        for (int i = 0; i < 5000; ++i) {
            baos.write(i);
        }
        Response response = target.request().post(Entity.entity((Object)baos.toByteArray(), (String)"application/octet-stream"));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String responseContent = (String)response.readEntity(String.class);
        this.LOG.debug((Object)String.format("Response: %s", responseContent));
    }

    @Test
    @DisplayName(value="Post Int")
    public void postInt() throws Exception {
        WebTarget target = client.target(this.generateURL("/postInt"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
        for (int i = 0; i < 5000; ++i) {
            baos.write(i);
        }
        Response response = target.request().post(Entity.entity((Object)baos.toByteArray(), (String)"application/octet-stream"));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String responseContent = (String)response.readEntity(String.class);
        this.LOG.debug((Object)String.format("Response: %s", responseContent));
    }

    @Test
    @DisplayName(value="Post Integer Produce")
    public void postIntegerProduce() throws Exception {
        WebTarget target = client.target(this.generateURL("/postIntegerProduce"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
        for (int i = 0; i < 5000; ++i) {
            baos.write(i);
        }
        Response response = target.request().post(Entity.entity((Object)baos.toByteArray(), (String)"application/octet-stream"));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String responseContent = (String)response.readEntity(String.class);
        this.LOG.debug((Object)String.format("Response: %s", responseContent));
    }

    @Test
    @DisplayName(value="Post Integer")
    public void postInteger() throws Exception {
        WebTarget target = client.target(this.generateURL("/postInteger"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
        for (int i = 0; i < 5000; ++i) {
            baos.write(i);
        }
        Response response = target.request().post(Entity.entity((Object)baos.toByteArray(), (String)"application/octet-stream"));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        String responseContent = (String)response.readEntity(String.class);
        this.LOG.debug((Object)String.format("Response: %s", responseContent));
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClass(DefaultMediaTypeCustomObject.class);
                war.addClasses(new Class[]{PortProviderUtil.class, DefaultMediaTypeResource.class});
                return war;
            }
        });
    }
}

