/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.GenericEntityDoubleWriter;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.GenericEntityFloatWriter;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.GenericEntityIntegerServerMessageBodyWriter;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.GenericEntityResource;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Generic Entity Test")
public class GenericEntityTest {
    static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    @BeforeAll
    public static void init() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void after() throws Exception {
        client.close();
        client = null;
    }

    private String generateURL(String path) {
        return PortProviderUtil.generateURL(path, GenericEntityTest.class.getSimpleName());
    }

    @Test
    @DisplayName(value="Test Doubles")
    public void testDoubles() {
        WebTarget base = client.target(this.generateURL("/doubles"));
        try {
            Response response = base.request().get();
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
            String body = (String)response.readEntity(String.class);
            Assertions.assertEquals((Object)"45.0D 50.0D ", (Object)body, (String)"The response doesn't contain the expected entity");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    @DisplayName(value="Test Floats")
    public void testFloats() {
        WebTarget base = client.target(this.generateURL("/floats"));
        try {
            Response response = base.request().get();
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
            String body = (String)response.readEntity(String.class);
            Assertions.assertEquals((Object)"45.0F 50.0F ", (Object)body, (String)"The response doesn't contain the expected entity");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testIntegers() {
        this.doTestIntegers("/integers");
    }

    @Test
    public void testIntegersNoResponse() {
        this.doTestIntegers("/integers-no-response");
    }

    private void doTestIntegers(String path) {
        WebTarget base = client.target(this.generateURL(path));
        try {
            Response response = base.request().get();
            Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
            String body = (String)response.readEntity(String.class);
            Assertions.assertEquals((Object)"45I 50I ", (Object)body, (String)"The response doesn't contain the expected entity");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClasses(new Class[]{PortProviderUtil.class, GenericEntityResource.class, GenericEntityDoubleWriter.class, GenericEntityFloatWriter.class, GenericEntityIntegerServerMessageBodyWriter.class});
                return war;
            }
        });
    }
}

