/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class MediaTypesWithSuffixHandlingTest {
    @RegisterExtension
    static QuarkusUnitTest testExtension = new QuarkusUnitTest().setArchiveProducer(() -> {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        archive.addClasses(new Class[]{TestResource.class, NoSuffixMessageBodyWriter.class, SuffixMessageBodyWriter.class});
        return archive;
    });

    @Test
    public void testWriterWithoutSuffix() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/writer/with-no-suffix", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"result - no suffix writer"), new Matcher[0]);
    }

    @Test
    public void testReaderWithoutSuffix() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/reader/with-no-suffix", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"from reader - result"), new Matcher[0]);
    }

    @Test
    public void testWriterWithSuffix() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/writer/with-suffix", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"result - suffix writer"), new Matcher[0]);
    }

    @Test
    public void testReaderWithSuffix() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/test/reader/with-suffix", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)"from reader suffix - result"), new Matcher[0]);
    }

    @Path(value="/test")
    public static class TestResource {
        @GET
        @Path(value="/writer/with-no-suffix")
        @Produces(value={"text/test"})
        public String writerSimple() {
            return "result";
        }

        @GET
        @Path(value="/writer/with-suffix")
        @Produces(value={"text/test+suffix"})
        public String writerSuffix() {
            return "result";
        }

        @GET
        @Path(value="/reader/with-no-suffix")
        @Consumes(value={"text/test"})
        public String readerSimple(Object fromReader) {
            return fromReader + " - result";
        }

        @GET
        @Path(value="/reader/with-suffix")
        @Consumes(value={"text/test+suffix"})
        public String readerSuffix(Object fromReader) {
            return fromReader + " - result";
        }
    }

    @Provider
    @Consumes(value={"text/test"})
    @Produces(value={"text/test"})
    public static class NoSuffixMessageBodyWriter
    implements ServerMessageBodyWriter<Object>,
    ServerMessageBodyReader<Object> {
        public boolean isWriteable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo target, MediaType mediaType) {
            return true;
        }

        public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
            Object response = (String)o;
            response = (String)response + " - no suffix writer";
            context.getOrCreateOutputStream().write(((String)response).getBytes(StandardCharsets.UTF_8));
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            throw new IllegalStateException("should never have been called");
        }

        public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            throw new IllegalStateException("should never have been called");
        }

        public boolean isReadable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo lazyMethod, MediaType mediaType) {
            return true;
        }

        public Object readFrom(Class<Object> type, Type genericType, MediaType mediaType, ServerRequestContext context) throws WebApplicationException {
            return "from reader";
        }

        public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
            throw new IllegalStateException("should never have been called");
        }

        public Object readFrom(Class<Object> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> multivaluedMap, InputStream inputStream) throws WebApplicationException {
            throw new IllegalStateException("should never have been called");
        }
    }

    @Provider
    @Consumes(value={"text/test+suffix"})
    @Produces(value={"text/test+suffix"})
    public static class SuffixMessageBodyWriter
    implements ServerMessageBodyWriter<Object>,
    ServerMessageBodyReader<Object> {
        public boolean isWriteable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo target, MediaType mediaType) {
            return true;
        }

        public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
            Object response = (String)o;
            response = (String)response + " - suffix writer";
            context.getOrCreateOutputStream().write(((String)response).getBytes(StandardCharsets.UTF_8));
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            throw new IllegalStateException("should never have been called");
        }

        public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            throw new IllegalStateException("should never have been called");
        }

        public boolean isReadable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo lazyMethod, MediaType mediaType) {
            return true;
        }

        public Object readFrom(Class<Object> type, Type genericType, MediaType mediaType, ServerRequestContext context) throws WebApplicationException {
            return "from reader suffix";
        }

        public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
            throw new IllegalStateException("should never have been called");
        }

        public Object readFrom(Class<Object> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> multivaluedMap, InputStream inputStream) throws WebApplicationException {
            throw new IllegalStateException("should never have been called");
        }
    }
}

