/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.MultiInterfaceResLocatorIntf1;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.MultiInterfaceResLocatorIntf2;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.MultiInterfaceResLocatorResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.MultiInterfaceResLocatorSubresource;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Multi Interface Res Locator Test")
public class MultiInterfaceResLocatorTest {
    @RegisterExtension
    static QuarkusUnitTest testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            war.addClass(MultiInterfaceResLocatorIntf1.class);
            war.addClass(MultiInterfaceResLocatorIntf2.class);
            war.addClasses(new Class[]{PortProviderUtil.class, MultiInterfaceResLocatorResource.class, MultiInterfaceResLocatorSubresource.class});
            return war;
        }
    });

    private String generateURL(String path) {
        return PortProviderUtil.generateURL(path, MultiInterfaceResLocatorTest.class.getSimpleName());
    }

    @Test
    @DisplayName(value="Test")
    public void test() throws Exception {
        Client client = ClientBuilder.newClient();
        Response response = client.target(this.generateURL("/test/hello1")).request().get();
        String entity = (String)response.readEntity(String.class);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)"resourceMethod1", (Object)entity, (String)"Wrong content of response");
        response = client.target(this.generateURL("/test/hello2")).request().get();
        entity = (String)response.readEntity(String.class);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)"resourceMethod2", (Object)entity, (String)"Wrong content of response");
        client.close();
    }
}

