/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ApplicationScopeObject;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.MultiInterfaceResLocatorIntf1;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.MultiInterfaceResLocatorIntf2;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.MultiInterfaceResLocatorResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.MultiInterfaceResLocatorSubresource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ParameterSubResClassSub;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ParameterSubResConcreteSubImpl;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ParameterSubResDoubleInterface;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ParameterSubResGenericInterface;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ParameterSubResGenericSub;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ParameterSubResInternalInterface;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ParameterSubResRoot;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ParameterSubResRootImpl;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ParameterSubResSub;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ParameterSubResSubImpl;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.RequestScopedObject;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Parameter Sub Res Test")
public class ParameterSubResTest {
    static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    private String generateURL(String path) {
        return PortProviderUtil.generateURL(path, ParameterSubResTest.class.getSimpleName());
    }

    @BeforeEach
    public void init() {
        client = ClientBuilder.newClient();
    }

    @AfterEach
    public void after() throws Exception {
        client.close();
    }

    @Test
    @DisplayName(value="Test Sub Resource")
    public void testSubResource() throws Exception {
        Response response = client.target(this.generateURL("/path/sub/fred")).request().get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)"Boo! - fred", (Object)response.readEntity(String.class), (String)"Wrong content of response");
    }

    @Test
    @DisplayName(value="Test Return Sub Resource As Class")
    public void testReturnSubResourceAsClass() throws Exception {
        Response response = client.target(this.generateURL("/path/subclass")).request().get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)"resourceCounter:1,appscope:1,requestScope:1", (Object)response.readEntity(String.class), (String)"Wrong response");
        response = client.target(this.generateURL("/path/subclass")).request().get();
        Assertions.assertEquals((Object)"resourceCounter:2,appscope:2,requestScope:1", (Object)response.readEntity(String.class), (String)"Wrong response");
    }

    @Test
    @DisplayName(value="Test Root")
    public void testRoot() throws Exception {
        Response response = client.target(this.generateURL("/generic/sub")).queryParam("foo", new Object[]{"42.0"}).request().get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)"42.0", (Object)response.readEntity(String.class), (String)"Wrong content of response");
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClass(MultiInterfaceResLocatorResource.class);
                war.addClass(MultiInterfaceResLocatorSubresource.class);
                war.addClasses(new Class[]{MultiInterfaceResLocatorIntf1.class});
                war.addClasses(new Class[]{MultiInterfaceResLocatorIntf2.class});
                war.addClass(ParameterSubResConcreteSubImpl.class);
                war.addClass(ParameterSubResDoubleInterface.class);
                war.addClass(ParameterSubResGenericInterface.class);
                war.addClass(ParameterSubResInternalInterface.class);
                war.addClasses(new Class[]{PortProviderUtil.class});
                war.addClass(ParameterSubResRoot.class);
                war.addClass(ParameterSubResClassSub.class);
                war.addClass(ApplicationScopeObject.class);
                war.addClass(RequestScopedObject.class);
                war.addClass(ParameterSubResSub.class);
                war.addClass(ParameterSubResSubImpl.class);
                war.addClasses(new Class[]{ParameterSubResRootImpl.class, ParameterSubResGenericSub.class});
                return war;
            }
        });
    }
}

