/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorAbstractAnnotationFreeResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorAnnotationFreeSubResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorBaseResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorCollectionResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorDirectory;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorQueueReceiver;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorReceiver;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorRootInterface;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorSubInterface;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorSubresource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorSubresource2;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorSubresource3;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResourceLocatorSubresource3Interface;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Resource Locator Test")
public class ResourceLocatorTest {
    static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    @BeforeAll
    public static void setup() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void close() {
        client.close();
    }

    private String generateURL(String path) {
        return PortProviderUtil.generateURL(path, ResourceLocatorTest.class.getSimpleName());
    }

    @Test
    @DisplayName(value="Test Proxied Subresource")
    public void testProxiedSubresource() throws Exception {
        WebTarget target = client.target(this.generateURL("/proxy/3"));
        jakarta.ws.rs.core.Response res = target.queryParam("foo", new Object[]{"1.2"}).queryParam("foo", new Object[]{"1.3"}).request().get();
        Assertions.assertEquals((int)200, (int)res.getStatus());
        res.close();
    }

    @Test
    @DisplayName(value="Test Subresource")
    public void testSubresource() throws Exception {
        jakarta.ws.rs.core.Response response = client.target(this.generateURL("/base/1/resources")).request().get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)ResourceLocatorSubresource.class.getName(), (Object)response.readEntity(String.class));
        response = client.target(this.generateURL("/base/1/resources/subresource2/stuff/2/bar")).request().get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)(ResourceLocatorSubresource2.class.getName() + "-2"), (Object)response.readEntity(String.class));
    }

    @Test
    @DisplayName(value="Test Same Uri")
    public void testSameUri() throws Exception {
        jakarta.ws.rs.core.Response response = client.target(this.generateURL("/directory/receivers/1")).request().delete();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)ResourceLocatorDirectory.class.getName(), (Object)response.readEntity(String.class));
    }

    @Test
    @DisplayName(value="Test Annotation Free Subresource")
    public void testAnnotationFreeSubresource() throws Exception {
        jakarta.ws.rs.core.Response response = client.target(this.generateURL("/collection/annotation_free_subresource")).request().get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertEquals((Object)response.readEntity(String.class), (Object)"got");
        Assertions.assertNotNull((Object)response.getHeaderString("Content-Type"));
        Assertions.assertEquals((Object)"text/plain;charset=UTF-8", (Object)response.getHeaderString("Content-Type"));
        Invocation.Builder request = client.target(this.generateURL("/collection/annotation_free_subresource")).request();
        jakarta.ws.rs.core.Response response2 = request.post(Entity.entity((Object)"hello!".getBytes(), (String)"text/plain"));
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response2.getStatus());
        Assertions.assertEquals((Object)"posted: hello!", (Object)response2.readEntity(String.class));
    }

    @Test
    @DisplayName(value="Test @BeanParam annotation in Subresources")
    public void testBeanParamsInSubresource() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/sub3/first/resources/subresource3?value=second", new Object[0])).then()).body(Matchers.is((Object)"first and second"), new Matcher[0]);
    }

    @Test
    public void testRoot() throws Exception {
        ((ValidatableResponse)((Response)RestAssured.given().get()).then()).body(Matchers.is((Object)"[app, ]"), new Matcher[0]);
    }

    static {
        testExtension = new QuarkusUnitTest().overrideConfigKey("quarkus.http.root-path", "/app").setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                ((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)war.addClass(ResourceLocatorQueueReceiver.class)).addClass(ResourceLocatorReceiver.class)).addClass(ResourceLocatorRootInterface.class)).addClass(ResourceLocatorSubInterface.class)).addClass(ResourceLocatorSubresource3Interface.class);
                war.addClasses(new Class[]{PortProviderUtil.class, ResourceLocatorAbstractAnnotationFreeResource.class, ResourceLocatorAnnotationFreeSubResource.class, ResourceLocatorBaseResource.class, ResourceLocatorCollectionResource.class, ResourceLocatorDirectory.class, ResourceLocatorSubresource.class, ResourceLocatorSubresource2.class, ResourceLocatorSubresource3.class});
                return war;
            }
        });
    }
}

