/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.ResponseInfoResource;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Response Info Test")
public class ResponseInfoTest {
    static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    @BeforeAll
    public static void before() throws Exception {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void close() {
        client.close();
    }

    private void basicTest(String path) {
        WebTarget base = client.target(PortProviderUtil.generateURL(path, ResponseInfoTest.class.getSimpleName()));
        Response response = base.request().get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        response.close();
    }

    @Test
    @DisplayName(value="Test Uri Info")
    public void testUriInfo() throws Exception {
        this.basicTest("/simple");
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClasses(new Class[]{PortProviderUtil.class, ResponseInfoTest.class});
                war.addClasses(new Class[]{ResponseInfoResource.class});
                return war;
            }
        });
    }
}

