/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.SpecialResourceApiResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.SpecialResourceDeleteResource;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.SpecialResourceStreamResource;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Special Resource Test")
public class SpecialResourceTest {
    static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    @BeforeAll
    public static void init() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void close() {
        client.close();
        client = null;
    }

    private String generateURL(String path) {
        return PortProviderUtil.generateURL(path, SpecialResourceTest.class.getSimpleName());
    }

    @Test
    @DisplayName(value="Test 631")
    public void test631() throws Exception {
        WebTarget base = client.target(this.generateURL("/delete"));
        Response response = base.request().method("DELETE", Entity.entity((Object)"hello", (String)"text/plain"));
        Assertions.assertEquals((int)Response.Status.NO_CONTENT.getStatusCode(), (int)response.getStatus());
        response.close();
    }

    @Test
    @DisplayName(value="Test 534")
    public void test534() throws Exception {
        WebTarget base = client.target(this.generateURL("/inputstream/test/json"));
        Response response = base.request().post(Entity.entity((Object)"hello world".getBytes(), (String)"application/octet-stream"));
        Assertions.assertEquals((int)Response.Status.NO_CONTENT.getStatusCode(), (int)response.getStatus());
        response.close();
    }

    @Test
    @DisplayName(value="Test 624")
    public void test624() throws Exception {
        WebTarget base = client.target(this.generateURL("/ApI/FuNc"));
        Response response = base.request().get();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        response.close();
    }

    @Test
    @DisplayName(value="Test 583")
    public void test583() throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPut method = new HttpPut(this.generateURL("/api"));
        HttpResponse response = null;
        try {
            method.setEntity((HttpEntity)new StringEntity("hello", ContentType.create((String)"vnd.net.juniper.space.target-management.targets+xml")));
            response = client.execute((HttpUriRequest)method);
            Assertions.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (response != null) {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClasses(new Class[]{SpecialResourceStreamResource.class, SpecialResourceApiResource.class, PortProviderUtil.class, SpecialResourceDeleteResource.class});
                return war;
            }
        });
    }
}

