/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.reactive.RestPath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class SubResourceRequestFilterTest {
    @RegisterExtension
    static QuarkusUnitTest testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
            war.addClasses(new Class[]{RestResource.class, RestSubResource.class, SingleExecutionFilter.class, MiddleRestResource.class});
            return war;
        }
    });

    @Test
    public void testSubResourceFilter() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/sub-resource/Bob/Builder", (Object[])new Object[0]).then()).header("single-filter", Matchers.equalTo((Object)"once"))).body(Matchers.equalTo((Object)"Bob Builder"), new Matcher[0])).statusCode(200);
    }

    @Provider
    public static class SingleExecutionFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
            if (requestContext.getProperty("been.here") != null) {
                throw new IllegalStateException("Filter should not have been called twice");
            }
            requestContext.setProperty("been.here", (Object)Boolean.TRUE);
            requestContext.getHeaders().putSingle((Object)"single-filter", (Object)"once");
        }
    }

    @ApplicationScoped
    public static class RestSubResource {
        @GET
        public Response hello(HttpHeaders headers, @RestPath String first, @RestPath String last) {
            return Response.ok((Object)(first + " " + last)).header("single-filter", (Object)headers.getHeaderString("single-filter")).build();
        }
    }

    @ApplicationScoped
    @Path(value="/")
    public static class MiddleRestResource {
        @Inject
        RestSubResource restSubResource;

        @Path(value="{last}")
        public RestSubResource hello() {
            return this.restSubResource;
        }
    }

    @Path(value="/")
    public static class RestResource {
        @Inject
        MiddleRestResource restSubResource;

        @Path(value="sub-resource/{first}")
        public MiddleRestResource hello(String first) {
            return this.restSubResource;
        }
    }
}

