/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resource.basic;

import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.WiderMappingDefaultOptions;
import io.quarkus.resteasy.reactive.server.test.resource.basic.resource.WiderMappingResource;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@DisplayName(value="Wider Mapping Negative Test")
public class WiderMappingNegativeTest {
    static Client client;
    @RegisterExtension
    static QuarkusUnitTest testExtension;

    private String generateURL(String path) {
        return PortProviderUtil.generateURL(path, WiderMappingNegativeTest.class.getSimpleName());
    }

    @BeforeAll
    public static void setup() {
        client = ClientBuilder.newClient();
    }

    @AfterAll
    public static void cleanup() {
        client.close();
    }

    @Test
    @DisplayName(value="Test Options")
    public void testOptions() {
        Response response = client.target(this.generateURL("/hello/int")).request().options();
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        Assertions.assertNotEquals((Object)response.readEntity(String.class), (Object)"hello");
        response.close();
    }

    static {
        testExtension = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

            @Override
            public JavaArchive get() {
                JavaArchive war = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
                war.addClasses(new Class[]{PortProviderUtil.class, WiderMappingResource.class, WiderMappingDefaultOptions.class});
                return war;
            }
        });
    }
}

