/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.response;

import io.quarkus.test.QuarkusUnitTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.annotation.Priority;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ChunkedResponseTest {
    private static final String LARGE_HELLO_STRING = "h" + "e".repeat(256) + "llo";
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)jar.addClasses(new Class[]{HelloResource.class})).addAsResource((Asset)new StringAsset("quarkus.rest.output-buffer-size = 256"), "application.properties"));

    @Test
    void chunked() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/hello/big", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)LARGE_HELLO_STRING), new Matcher[0])).header("Transfer-encoding", "chunked");
    }

    @Test
    void notChunked() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/hello/small", new Object[0])).then()).statusCode(200)).body(CoreMatchers.equalTo((Object)"hello"), new Matcher[0])).header("Transfer-encoding", CoreMatchers.nullValue());
    }

    @Path(value="hello")
    public static final class HelloResource {
        @GET
        @Path(value="big")
        public String helloBig() {
            return LARGE_HELLO_STRING;
        }

        @GET
        @Path(value="small")
        public String helloSmall() {
            return "hello";
        }
    }

    @Provider
    @Priority(value=5001)
    public static final class CustomStringMessageBodyWriter2
    extends CustomStringMessageBodyWriter {
        @Override
        public void writeResponse(String o, Type genericType, ServerRequestContext context) throws WebApplicationException {
            try (OutputStream stream = context.getOrCreateOutputStream();){
                stream.write(o.getBytes());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Provider
    public static class CustomStringMessageBodyWriter
    implements ServerMessageBodyWriter<String> {
        public boolean isWriteable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo target, MediaType mediaType) {
            return true;
        }

        public void writeResponse(String o, Type genericType, ServerRequestContext context) throws WebApplicationException {
            context.serverResponse().end(o);
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return true;
        }

        public void writeTo(String o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            entityStream.write(o.getBytes(StandardCharsets.UTF_8));
        }
    }
}

