/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resteasy.async.filters;

import io.quarkus.resteasy.reactive.server.test.ExceptionUtil;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncFilterException;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestFilter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public abstract class AsyncRequestFilter
implements ResteasyReactiveContainerRequestFilter {
    private final String name;
    private volatile String callbackException;
    private static final Logger LOG = Logger.getLogger(AsyncRequestFilter.class);

    public AsyncRequestFilter(String name) {
        this.name = name;
    }

    public void filter(ResteasyReactiveContainerRequestContext ctx) {
        ctx.getHeaders().add((Object)("RequestFilterCallback" + this.name), (Object)String.valueOf(this.callbackException));
        this.callbackException = null;
        String action = ctx.getHeaderString(this.name);
        LOG.debug((Object)("Filter request for " + this.name + " with action: " + action));
        if (!"sync-pass".equals(action)) {
            if ("sync-fail".equals(action)) {
                ctx.abortWith(Response.ok((Object)this.name).build());
            } else if ("async-pass".equals(action)) {
                ctx.suspend();
                ExecutorService executor = Executors.newSingleThreadExecutor();
                executor.submit(() -> ctx.resume());
            } else if ("async-pass-instant".equals(action)) {
                ctx.suspend();
                ctx.resume();
            } else if ("async-fail".equals(action)) {
                ctx.suspend();
                ExecutorService executor = Executors.newSingleThreadExecutor();
                executor.submit(() -> ctx.abortWith(Response.ok((Object)this.name).build()));
            } else if ("async-fail-instant".equals(action)) {
                ctx.suspend();
                ctx.abortWith(Response.ok((Object)this.name).build());
            } else if ("async-throw-late".equals(action)) {
                ctx.suspend();
                ServerRequestContext resteasyReactiveCallbackContext = ctx.getServerRequestContext();
                ExecutorService executor = Executors.newSingleThreadExecutor();
                executor.submit(() -> {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)"Error:", (Throwable)e);
                    }
                    resteasyReactiveCallbackContext.registerCompletionCallback(t -> {
                        if (this.callbackException != null) {
                            throw ExceptionUtil.removeStackTrace(new RuntimeException("Callback called twice"));
                        }
                        this.callbackException = Objects.toString(t);
                    });
                    if ("true".equals(ctx.getHeaderString("UseExceptionMapper"))) {
                        ctx.resume((Throwable)ExceptionUtil.removeStackTrace(new AsyncFilterException("ouch")));
                    } else {
                        ctx.resume(ExceptionUtil.removeStackTrace(new Throwable("ouch")));
                    }
                });
            }
        }
        LOG.debug((Object)("Filter request for " + this.name + " with action: " + action + " done"));
    }
}

