/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resteasy.async.filters;

import io.quarkus.resteasy.reactive.server.test.ExceptionUtil;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncFilterException;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncFilterExceptionMapper;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncPreMatchRequestFilter1;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncPreMatchRequestFilter2;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncPreMatchRequestFilter3;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncRequestFilter;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncRequestFilter1;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncRequestFilter2;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncRequestFilter3;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncRequestFilterResource;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncResponseFilter;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncResponseFilter1;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncResponseFilter2;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncResponseFilter3;
import io.quarkus.resteasy.reactive.server.test.simple.PortProviderUtil;
import io.quarkus.test.QuarkusUnitTest;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class AsyncRequestFilterTest {
    protected static final Logger log = Logger.getLogger((String)AsyncRequestFilterTest.class.getName());
    @RegisterExtension
    static QuarkusUnitTest test = new QuarkusUnitTest().setArchiveProducer((Supplier)new Supplier<JavaArchive>(){

        @Override
        public JavaArchive get() {
            return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{PortProviderUtil.class, AsyncRequestFilter.class, AsyncRequestFilter1.class, AsyncRequestFilter2.class, AsyncRequestFilter3.class, AsyncPreMatchRequestFilter1.class, AsyncPreMatchRequestFilter2.class, AsyncPreMatchRequestFilter3.class, AsyncResponseFilter.class, AsyncResponseFilter1.class, AsyncResponseFilter2.class, AsyncResponseFilter3.class, AsyncFilterException.class, AsyncFilterExceptionMapper.class, AsyncRequestFilterResource.class, ExceptionUtil.class});
        }
    });

    @Test
    public void testRequestFilters() throws Exception {
        Client client = ClientBuilder.newClient();
        WebTarget base = client.target(PortProviderUtil.generateURL("/"));
        Response response = base.request().header("Filter1", (Object)"sync-pass").header("Filter2", (Object)"sync-pass").header("Filter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"sync-fail").header("Filter2", (Object)"sync-fail").header("Filter3", (Object)"sync-fail").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"Filter1", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"sync-pass").header("Filter2", (Object)"sync-fail").header("Filter3", (Object)"sync-fail").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"Filter2", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"sync-pass").header("Filter2", (Object)"sync-pass").header("Filter3", (Object)"sync-fail").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"Filter3", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"async-pass").header("Filter2", (Object)"sync-pass").header("Filter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"async-pass").header("Filter2", (Object)"async-pass").header("Filter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"async-pass").header("Filter2", (Object)"async-pass").header("Filter3", (Object)"async-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"async-pass").header("Filter2", (Object)"sync-pass").header("Filter3", (Object)"async-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"sync-pass").header("Filter2", (Object)"async-pass").header("Filter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"async-fail").header("Filter2", (Object)"sync-fail").header("Filter3", (Object)"sync-fail").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"Filter1", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"async-pass").header("Filter2", (Object)"sync-fail").header("Filter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"Filter2", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"async-pass").header("Filter2", (Object)"async-fail").header("Filter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"Filter2", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"async-pass-instant").header("Filter2", (Object)"sync-pass").header("Filter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("Filter1", (Object)"async-fail-instant").header("Filter2", (Object)"sync-pass").header("Filter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"Filter1", (Object)response.readEntity(String.class));
        client.close();
    }

    @Test
    public void testPreMatchRequestFilters() throws Exception {
        Client client = ClientBuilder.newClient();
        WebTarget base = client.target(PortProviderUtil.generateURL("/"));
        Response response = base.request().header("PreMatchFilter1", (Object)"sync-pass").header("PreMatchFilter2", (Object)"sync-pass").header("PreMatchFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("PreMatchFilter1", (Object)"sync-fail").header("PreMatchFilter2", (Object)"sync-fail").header("PreMatchFilter3", (Object)"sync-fail").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"PreMatchFilter1", (Object)response.readEntity(String.class));
        response = base.request().header("PreMatchFilter1", (Object)"sync-pass").header("PreMatchFilter2", (Object)"sync-fail").header("PreMatchFilter3", (Object)"sync-fail").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"PreMatchFilter2", (Object)response.readEntity(String.class));
        response = base.request().header("PreMatchFilter1", (Object)"sync-pass").header("PreMatchFilter2", (Object)"sync-pass").header("PreMatchFilter3", (Object)"sync-fail").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"PreMatchFilter3", (Object)response.readEntity(String.class));
        response = base.request().header("PreMatchFilter1", (Object)"async-pass").header("PreMatchFilter2", (Object)"sync-pass").header("PreMatchFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        response = base.request().header("PreMatchFilter1", (Object)"async-pass").header("PreMatchFilter2", (Object)"async-pass").header("PreMatchFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("PreMatchFilter1", (Object)"async-pass").header("PreMatchFilter2", (Object)"async-pass").header("PreMatchFilter3", (Object)"async-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("PreMatchFilter1", (Object)"async-pass").header("PreMatchFilter2", (Object)"sync-pass").header("PreMatchFilter3", (Object)"async-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("PreMatchFilter1", (Object)"sync-pass").header("PreMatchFilter2", (Object)"async-pass").header("PreMatchFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("PreMatchFilter1", (Object)"async-fail").header("PreMatchFilter2", (Object)"sync-fail").header("PreMatchFilter3", (Object)"sync-fail").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"PreMatchFilter1", (Object)response.readEntity(String.class));
        response = base.request().header("PreMatchFilter1", (Object)"async-pass").header("PreMatchFilter2", (Object)"sync-fail").header("PreMatchFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"PreMatchFilter2", (Object)response.readEntity(String.class));
        response = base.request().header("PreMatchFilter1", (Object)"async-pass").header("PreMatchFilter2", (Object)"async-fail").header("PreMatchFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"PreMatchFilter2", (Object)response.readEntity(String.class));
        client.close();
    }

    @Test
    public void testResponseFilters() throws Exception {
        Client client = ClientBuilder.newClient();
        WebTarget base = client.target(PortProviderUtil.generateURL("/"));
        Response response = base.request().header("ResponseFilter1", (Object)"sync-pass").header("ResponseFilter2", (Object)"sync-pass").header("ResponseFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"sync-fail").header("ResponseFilter2", (Object)"sync-pass").header("ResponseFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"ResponseFilter1", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"sync-pass").header("ResponseFilter2", (Object)"sync-fail").header("ResponseFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"ResponseFilter2", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"sync-pass").header("ResponseFilter2", (Object)"sync-pass").header("ResponseFilter3", (Object)"sync-fail").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"ResponseFilter3", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"async-pass").header("ResponseFilter2", (Object)"sync-pass").header("ResponseFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        response = base.request().header("ResponseFilter1", (Object)"async-pass").header("ResponseFilter2", (Object)"async-pass").header("ResponseFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"async-pass").header("ResponseFilter2", (Object)"async-pass").header("ResponseFilter3", (Object)"async-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"async-pass").header("ResponseFilter2", (Object)"sync-pass").header("ResponseFilter3", (Object)"async-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"sync-pass").header("ResponseFilter2", (Object)"async-pass").header("ResponseFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"async-fail").header("ResponseFilter2", (Object)"sync-pass").header("ResponseFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"ResponseFilter1", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"async-pass").header("ResponseFilter2", (Object)"sync-fail").header("ResponseFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"ResponseFilter2", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"async-pass").header("ResponseFilter2", (Object)"async-fail").header("ResponseFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"ResponseFilter2", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"async-pass-instant").header("ResponseFilter2", (Object)"sync-pass").header("ResponseFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        response = base.request().header("ResponseFilter1", (Object)"async-fail-instant").header("ResponseFilter2", (Object)"sync-pass").header("ResponseFilter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"ResponseFilter1", (Object)response.readEntity(String.class));
        client.close();
    }

    @Test
    public void testResponseFilters2() throws Exception {
        Client client = ClientBuilder.newClient();
        WebTarget base = client.target(PortProviderUtil.generateURL("/async"));
        Response response = base.request().header("ResponseFilter1", (Object)"sync-pass").header("ResponseFilter2", (Object)"sync-pass").header("ResponseFilter3", (Object)"async-fail-late").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"ResponseFilter3", (Object)response.readEntity(String.class));
        client.close();
    }

    @Test
    public void testResponseFiltersThrow() throws Exception {
        Client client = ClientBuilder.newClient();
        this.testResponseFilterThrow(client, "/callback-async", false);
        this.testResponseFilterThrow(client, "/callback", false);
        this.testResponseFilterThrow(client, "/callback-async", true);
        this.testResponseFilterThrow(client, "/callback", true);
        client.close();
    }

    private void testResponseFilterThrow(Client client, String target, boolean useExceptionMapper) {
        WebTarget base = client.target(PortProviderUtil.generateURL(target));
        Response response = base.request().header("ResponseFilter1", (Object)"sync-pass").header("ResponseFilter2", (Object)"sync-pass").header("UseExceptionMapper", (Object)useExceptionMapper).header("ResponseFilter3", (Object)"async-throw-late").get();
        Assertions.assertEquals((int)500, (int)response.getStatus());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        response = base.request().get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        if (useExceptionMapper) {
            Assertions.assertEquals((Object)(AsyncFilterException.class.getName() + ": ouch"), (Object)response.getHeaders().getFirst((Object)"ResponseFilterCallbackResponseFilter3"));
        } else {
            Assertions.assertEquals((Object)"java.lang.Throwable: ouch", (Object)response.getHeaders().getFirst((Object)"ResponseFilterCallbackResponseFilter3"));
        }
        response = base.request().header("Filter1", (Object)"sync-pass").header("Filter2", (Object)"sync-pass").header("UseExceptionMapper", (Object)useExceptionMapper).header("Filter3", (Object)"async-throw-late").get();
        if (useExceptionMapper) {
            Assertions.assertEquals((int)Response.Status.ACCEPTED.getStatusCode(), (int)response.getStatus());
            Assertions.assertEquals((Object)"exception was mapped", (Object)response.readEntity(String.class));
        } else {
            Assertions.assertEquals((int)500, (int)response.getStatus());
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        response = base.request().get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        if (useExceptionMapper) {
            Assertions.assertEquals((Object)(AsyncFilterException.class.getName() + ": ouch"), (Object)response.getHeaders().getFirst((Object)"RequestFilterCallbackFilter3"));
        } else {
            Assertions.assertEquals((Object)"java.lang.Throwable: ouch", (Object)response.getHeaders().getFirst((Object)"RequestFilterCallbackFilter3"));
        }
    }

    @Test
    public void testRequestFiltersGuessReturnType() throws Exception {
        Client client = ClientBuilder.newClient();
        WebTarget base = client.target(PortProviderUtil.generateURL("/non-response"));
        Response response = base.request().header("Filter1", (Object)"async-pass").header("Filter2", (Object)"sync-pass").header("Filter3", (Object)"sync-pass").get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"resource", (Object)response.readEntity(String.class));
        client.close();
    }
}

