/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.resteasy.async.filters;

import io.quarkus.resteasy.reactive.server.test.ExceptionUtil;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncFilterException;
import io.quarkus.resteasy.reactive.server.test.resteasy.async.filters.AsyncRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerResponseFilter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public abstract class AsyncResponseFilter
implements ResteasyReactiveContainerResponseFilter {
    private final String name;
    private volatile String callbackException;
    private static final Logger LOG = Logger.getLogger(AsyncRequestFilter.class);

    public AsyncResponseFilter(String name) {
        this.name = name;
    }

    public void filter(ResteasyReactiveContainerRequestContext requestContext, ContainerResponseContext ctx) {
        for (Map.Entry entry : requestContext.getHeaders().entrySet()) {
            if (!((String)entry.getKey()).startsWith("RequestFilterCallback")) continue;
            this.addValuesToContext(ctx, entry);
        }
        ctx.getHeaders().add((Object)("ResponseFilterCallback" + this.name), (Object)String.valueOf(this.callbackException));
        this.callbackException = null;
        String action = requestContext.getHeaderString(this.name);
        LOG.debug((Object)("Filter response for " + this.name + " with action: " + action));
        if (!"sync-pass".equals(action)) {
            if ("sync-fail".equals(action)) {
                ctx.setEntity((Object)this.name);
            } else if ("async-pass".equals(action)) {
                requestContext.suspend();
                executor = Executors.newSingleThreadExecutor();
                executor.submit(() -> requestContext.resume());
            } else if ("async-pass-instant".equals(action)) {
                requestContext.suspend();
                requestContext.resume();
            } else if ("async-fail".equals(action)) {
                requestContext.suspend();
                executor = Executors.newSingleThreadExecutor();
                executor.submit(() -> {
                    ctx.setEntity((Object)this.name);
                    requestContext.resume();
                });
            } else if ("async-fail-late".equals(action)) {
                requestContext.suspend();
                executor = Executors.newSingleThreadExecutor();
                executor.submit(() -> {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)"Error:", (Throwable)e);
                    }
                    ctx.setEntity((Object)this.name);
                    requestContext.resume();
                });
            } else if ("async-fail-instant".equals(action)) {
                requestContext.suspend();
                ctx.setEntity((Object)this.name);
                requestContext.resume();
            } else {
                if ("sync-throw".equals(action)) {
                    throw ExceptionUtil.removeStackTrace(new AsyncFilterException("ouch"));
                }
                if ("async-throw-late".equals(action)) {
                    requestContext.suspend();
                    ServerRequestContext resteasyReactiveCallbackContext = requestContext.getServerRequestContext();
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    executor.submit(() -> {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            LOG.debug((Object)"Error:", (Throwable)e);
                        }
                        ctx.setEntity((Object)this.name);
                        resteasyReactiveCallbackContext.registerCompletionCallback(t -> {
                            if (this.callbackException != null) {
                                throw ExceptionUtil.removeStackTrace(new RuntimeException("Callback called twice"));
                            }
                            this.callbackException = Objects.toString(t);
                        });
                        if ("true".equals(requestContext.getHeaderString("UseExceptionMapper"))) {
                            requestContext.resume((Throwable)ExceptionUtil.removeStackTrace(new AsyncFilterException("ouch")));
                        } else {
                            requestContext.resume(ExceptionUtil.removeStackTrace(new Throwable("ouch")));
                        }
                    });
                }
            }
        }
        LOG.debug((Object)("Filter response for " + this.name + " with action: " + action + " done"));
    }

    private void addValuesToContext(ContainerResponseContext responseContext, Map.Entry<String, List<String>> entry) {
        responseContext.getHeaders().addAll((Object)entry.getKey(), entry.getValue());
    }
}

