/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.security.test.utils.TestIdentityController;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public abstract class AbstractPermissionsAllowedTestCase {
    @BeforeAll
    public static void setupUsers() {
        TestIdentityController.resetRoles().add("admin", "admin").add("user", "user").add("viewer", "viewer");
    }

    @Test
    public void testStringPermission2RequiredPermissions() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").post("/permissions", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"done"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").post("/permissions", new Object[0])).then()).statusCode(403);
    }

    @Test
    public void testStringPermission2RequiredPermissionsNonBlocking() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").post("/permissions-non-blocking", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"done"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").post("/permissions-non-blocking", new Object[0])).then()).statusCode(403);
    }

    @Test
    public void testStringPermissionOneOfPermissionsAndActions() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get("/permissions/admin", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"admin"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").get("/permissions/admin", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"admin"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("viewer", "viewer").get("/permissions/admin", new Object[0])).then()).statusCode(403);
    }

    @Test
    public void testStringPermissionOneOfPermissionsAndActionsNonBlocking() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get("/permissions-non-blocking/admin", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"admin"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").get("/permissions-non-blocking/admin", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"admin"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("viewer", "viewer").get("/permissions-non-blocking/admin", new Object[0])).then()).statusCode(403);
    }

    @Test
    public void testBlockingAccessToIdentityOnIOThread() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").get("/permissions/admin/security-identity", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"user"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get("/permissions/admin/security-identity", new Object[0])).then()).statusCode(403);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("user", "user").get("/permissions-non-blocking/admin/security-identity", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"user"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").get("/permissions-non-blocking/admin/security-identity", new Object[0])).then()).statusCode(403);
    }

    @Test
    public void testCustomPermissionNonBlocking() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").param("greeting", new Object[]{"hello"}).get("/permissions-non-blocking/custom-permission", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").param("greeting", new Object[]{"hi"}).get("/permissions-non-blocking/custom-permission", new Object[0])).then()).statusCode(403);
    }

    @Test
    public void testCustomPermission() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").param("greeting", new Object[]{"hello"}).get("/permissions/custom-permission", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"hello"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().auth().basic("admin", "admin").param("greeting", new Object[]{"hi"}).get("/permissions/custom-permission", new Object[0])).then()).statusCode(403);
    }

    @Test
    public void testCustomPermissionWithAdditionalArgs() {
        ((ValidatableResponse)AbstractPermissionsAllowedTestCase.reqAutodetectedExtraArgs("admin", "Ostrava").statusCode(200)).body(Matchers.equalTo((Object)"so long Nelson 3 Ostrava"), new Matcher[0]);
        ((ValidatableResponse)AbstractPermissionsAllowedTestCase.reqAutodetectedExtraArgs("user", "Prague").statusCode(200)).body(Matchers.equalTo((Object)"so long Nelson 3 Prague"), new Matcher[0]);
        AbstractPermissionsAllowedTestCase.reqAutodetectedExtraArgs("user", "Ostrava").statusCode(403);
        AbstractPermissionsAllowedTestCase.reqAutodetectedExtraArgs("viewer", "Ostrava").statusCode(403);
        ((ValidatableResponse)AbstractPermissionsAllowedTestCase.reqExplicitlyMarkedExtraArgs("admin", "Ostrava").statusCode(200)).body(Matchers.equalTo((Object)"so long Nelson 3 Ostrava"), new Matcher[0]);
        ((ValidatableResponse)AbstractPermissionsAllowedTestCase.reqExplicitlyMarkedExtraArgs("user", "Prague").statusCode(200)).body(Matchers.equalTo((Object)"so long Nelson 3 Prague"), new Matcher[0]);
        AbstractPermissionsAllowedTestCase.reqExplicitlyMarkedExtraArgs("user", "Ostrava").statusCode(403);
        AbstractPermissionsAllowedTestCase.reqExplicitlyMarkedExtraArgs("viewer", "Ostrava").statusCode(403);
    }

    private static ValidatableResponse reqAutodetectedExtraArgs(String user, String place) {
        return (ValidatableResponse)((Response)RestAssured.given().auth().basic(user, user).pathParam("goodbye", (Object)"so long").header("toWhom", (Object)"Nelson", new Object[0]).cookie("day", (Object)3, new Object[0]).body(place).post("/permissions-non-blocking/custom-perm-with-args/{goodbye}", new Object[0])).then();
    }

    private static ValidatableResponse reqExplicitlyMarkedExtraArgs(String user, String place) {
        return (ValidatableResponse)((Response)RestAssured.given().auth().basic(user, user).pathParam("goodbye", (Object)"so long").header("toWhom", (Object)"Nelson", new Object[0]).cookie("day", (Object)3, new Object[0]).body(place).post("/permissions/custom-perm-with-args/{goodbye}", new Object[0])).then();
    }
}

