/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedBlockingResource;
import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedResource;
import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedService;
import io.quarkus.resteasy.reactive.server.test.security.RolesAllowedServiceResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredParentResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredResource;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredResourceInterface;
import io.quarkus.resteasy.reactive.server.test.security.UnsecuredSubResource;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.interceptor.check.RolesAllowedCheck;
import io.quarkus.security.spi.runtime.AuthenticationFailureEvent;
import io.quarkus.security.spi.runtime.AuthenticationSuccessEvent;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.ObservesAsync;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractSecurityEventTest {
    protected static final Class<?>[] TEST_CLASSES = new Class[]{RolesAllowedResource.class, RolesAllowedBlockingResource.class, TestIdentityProvider.class, TestIdentityController.class, UnsecuredResource.class, UnsecuredSubResource.class, RolesAllowedService.class, RolesAllowedServiceResource.class, EventObserver.class, UnsecuredResourceInterface.class, UnsecuredParentResource.class};
    @Inject
    EventObserver observer;
    @Inject
    HttpBuildTimeConfig httpBuildTimeConfig;

    @BeforeEach
    public void clean() {
        this.observer.asyncAuthZFailureEvents.clear();
        this.observer.syncEvents.clear();
        this.observer.authNFailureEvents.clear();
    }

    @BeforeAll
    public static void setupUsers() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"}).add("user", "user", new String[]{"user"});
    }

    private boolean isProactiveAuth() {
        return this.httpBuildTimeConfig.auth.proactive;
    }

    @Test
    public void testAuthenticationEvent() {
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("unknown", "unknown").get("/unsecured/authenticated", new Object[0])).then()).statusCode(401);
        Assertions.assertEquals((int)1, (int)this.observer.authNFailureEvents.size());
        AuthenticationFailureEvent event = this.observer.authNFailureEvents.get(0);
        Assertions.assertNull((Object)event.getSecurityIdentity());
        Assertions.assertTrue((boolean)(event.getAuthenticationFailure() instanceof AuthenticationFailedException));
        Assertions.assertNotNull(event.getEventProperties().get(RoutingContext.class.getName()));
    }

    @Test
    public void testRolesAllowed() {
        ((ValidatableResponse)RestAssured.get((String)"/roles", (Object[])new Object[0]).then()).statusCode(401);
        this.assertSyncObserved(1);
        this.assertAsyncAuthZFailureObserved(1);
        SecurityIdentity anonymousIdentity = this.observer.syncEvents.get(0).getSecurityIdentity();
        Assertions.assertNotNull((Object)anonymousIdentity);
        Assertions.assertTrue((boolean)anonymousIdentity.isAnonymous());
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("user", "user").get("/roles/admin", new Object[0])).then()).statusCode(403);
        this.assertSyncObserved(3);
        AuthenticationSuccessEvent successEvent = (AuthenticationSuccessEvent)this.observer.syncEvents.get(1);
        SecurityIdentity identity = successEvent.getSecurityIdentity();
        Assertions.assertNotNull((Object)identity);
        Assertions.assertEquals((Object)"user", (Object)identity.getPrincipal().getName());
        RoutingContext routingContext = (RoutingContext)successEvent.getEventProperties().get(RoutingContext.class.getName());
        Assertions.assertNotNull((Object)routingContext);
        Assertions.assertTrue((boolean)routingContext.request().path().endsWith("/roles/admin"));
        this.assertAsyncAuthZFailureObserved(2);
        ((ValidatableResponse)RestAssured.get((String)"/roles-blocking", (Object[])new Object[0]).then()).statusCode(401);
        this.assertSyncObserved(4);
        this.assertAsyncAuthZFailureObserved(3);
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("user", "user").get("/roles-blocking/admin", new Object[0])).then()).statusCode(403);
        this.assertSyncObserved(6);
        successEvent = (AuthenticationSuccessEvent)this.observer.syncEvents.get(4);
        identity = successEvent.getSecurityIdentity();
        Assertions.assertNotNull((Object)identity);
        Assertions.assertEquals((Object)"user", (Object)identity.getPrincipal().getName());
        routingContext = (RoutingContext)successEvent.getEventProperties().get(RoutingContext.class.getName());
        Assertions.assertNotNull((Object)routingContext);
        Assertions.assertTrue((boolean)routingContext.request().path().endsWith("/roles-blocking/admin"));
        this.assertAsyncAuthZFailureObserved(4);
    }

    @Test
    public void testNestedRolesAllowed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get("/roles-service/hello", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello from Service!"), new Matcher[0]);
        this.assertSyncObserved(3, false, false);
        AuthenticationSuccessEvent successEvent = (AuthenticationSuccessEvent)this.observer.syncEvents.get(0);
        SecurityIdentity identity = successEvent.getSecurityIdentity();
        Assertions.assertNotNull((Object)identity);
        Assertions.assertEquals((Object)"admin", (Object)identity.getPrincipal().getName());
        RoutingContext routingContext = (RoutingContext)successEvent.getEventProperties().get(RoutingContext.class.getName());
        Assertions.assertNotNull((Object)routingContext);
        Assertions.assertTrue((boolean)routingContext.request().path().endsWith("/roles-service/hello"));
        AuthorizationSuccessEvent authZSuccessEvent = (AuthorizationSuccessEvent)this.observer.syncEvents.get(1);
        Assertions.assertEquals((Object)identity, (Object)authZSuccessEvent.getSecurityIdentity());
        identity = authZSuccessEvent.getSecurityIdentity();
        Assertions.assertEquals((Object)routingContext, authZSuccessEvent.getEventProperties().get(RoutingContext.class.getName()));
        authZSuccessEvent = (AuthorizationSuccessEvent)this.observer.syncEvents.get(2);
        Assertions.assertEquals((Object)identity, (Object)authZSuccessEvent.getSecurityIdentity());
        Assertions.assertNull(authZSuccessEvent.getEventProperties().get(RoutingContext.class.getName()));
        this.assertAsyncAuthZFailureObserved(0);
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("user", "user").get("/roles-service/hello", new Object[0])).then()).statusCode(403);
        this.assertSyncObserved(6, false, false);
        successEvent = (AuthenticationSuccessEvent)this.observer.syncEvents.get(3);
        identity = successEvent.getSecurityIdentity();
        Assertions.assertNotNull((Object)identity);
        Assertions.assertEquals((Object)"user", (Object)identity.getPrincipal().getName());
        routingContext = (RoutingContext)successEvent.getEventProperties().get(RoutingContext.class.getName());
        Assertions.assertNotNull((Object)routingContext);
        Assertions.assertTrue((boolean)routingContext.request().path().endsWith("/roles-service/hello"));
        authZSuccessEvent = (AuthorizationSuccessEvent)this.observer.syncEvents.get(4);
        Assertions.assertEquals((Object)identity, (Object)authZSuccessEvent.getSecurityIdentity());
        Assertions.assertEquals((Object)routingContext, authZSuccessEvent.getEventProperties().get(RoutingContext.class.getName()));
        this.assertAsyncAuthZFailureObserved(1, false);
        AuthorizationFailureEvent authZFailureEvent = this.observer.asyncAuthZFailureEvents.get(0);
        SecurityIdentity userIdentity = authZFailureEvent.getSecurityIdentity();
        Assertions.assertNotNull((Object)userIdentity);
        Assertions.assertTrue((boolean)userIdentity.hasRole("user"));
        Assertions.assertEquals((Object)"user", (Object)userIdentity.getPrincipal().getName());
        Assertions.assertNull(authZFailureEvent.getEventProperties().get(RoutingContext.class.getName()));
        Assertions.assertEquals((Object)RolesAllowedCheck.class.getName(), (Object)authZFailureEvent.getAuthorizationContext());
    }

    @Test
    public void testAuthenticated() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get("/unsecured/authenticated", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"authenticated"), new Matcher[0]);
        this.assertSyncObserved(2);
        this.assertAsyncAuthZFailureObserved(0);
        AuthenticationSuccessEvent authNSuccess = (AuthenticationSuccessEvent)this.observer.syncEvents.get(0);
        SecurityIdentity identity = authNSuccess.getSecurityIdentity();
        Assertions.assertNotNull((Object)identity);
        Assertions.assertEquals((Object)"admin", (Object)identity.getPrincipal().getName());
        AuthorizationSuccessEvent authZSuccess = (AuthorizationSuccessEvent)this.observer.syncEvents.get(1);
        Assertions.assertEquals((Object)identity, (Object)authZSuccess.getSecurityIdentity());
        RoutingContext routingContext = (RoutingContext)authZSuccess.getEventProperties().get(RoutingContext.class.getName());
        Assertions.assertTrue((boolean)routingContext.request().path().endsWith("/unsecured/authenticated"));
        ((ValidatableResponse)((Response)RestAssured.given().get("/unsecured/authenticated", new Object[0])).then()).statusCode(401);
        this.assertSyncObserved(3);
        this.assertAsyncAuthZFailureObserved(1);
        Assertions.assertEquals((int)1, (int)this.observer.asyncAuthZFailureEvents.size());
        AuthorizationFailureEvent authZFailure = this.observer.asyncAuthZFailureEvents.get(0);
        SecurityIdentity anonymousIdentity = authZFailure.getSecurityIdentity();
        Assertions.assertNotNull((Object)anonymousIdentity);
        Assertions.assertTrue((boolean)anonymousIdentity.isAnonymous());
        routingContext = (RoutingContext)authZFailure.getEventProperties().get(RoutingContext.class.getName());
        Assertions.assertNotNull((Object)routingContext);
        Assertions.assertTrue((boolean)routingContext.request().path().endsWith("/unsecured/authenticated"));
    }

    @Test
    public void testDenyAll() {
        ((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get("/unsecured/denyAll", new Object[0])).then()).statusCode(403);
        this.assertSyncObserved(2);
        this.assertAsyncAuthZFailureObserved(1);
        AuthorizationFailureEvent authZFailure = (AuthorizationFailureEvent)this.observer.syncEvents.get(1);
        SecurityIdentity adminIdentity = authZFailure.getSecurityIdentity();
        Assertions.assertNotNull((Object)adminIdentity);
        Assertions.assertEquals((Object)"admin", (Object)adminIdentity.getPrincipal().getName());
        Assertions.assertTrue((boolean)adminIdentity.hasRole("admin"));
        Assertions.assertEquals((Object)adminIdentity, (Object)this.observer.asyncAuthZFailureEvents.get(0).getSecurityIdentity());
        AuthenticationSuccessEvent authNSuccess = (AuthenticationSuccessEvent)this.observer.syncEvents.get(0);
        Assertions.assertEquals((Object)adminIdentity, (Object)authNSuccess.getSecurityIdentity());
        RoutingContext routingContext = (RoutingContext)authNSuccess.getEventProperties().get(RoutingContext.class.getName());
        Assertions.assertNotNull((Object)routingContext);
        Assertions.assertTrue((boolean)routingContext.request().path().endsWith("unsecured/denyAll"));
        Assertions.assertEquals((Object)routingContext, authZFailure.getEventProperties().get(RoutingContext.class.getName()));
        ((ValidatableResponse)((Response)RestAssured.given().get("/unsecured/authenticated", new Object[0])).then()).statusCode(401);
        this.assertSyncObserved(3);
        this.assertAsyncAuthZFailureObserved(2);
    }

    @Test
    public void testPermitAll() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic("admin", "admin").get("/unsecured/permitAll", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"permitAll"), new Matcher[0]);
        this.assertAsyncAuthZFailureObserved(0);
        if (this.isProactiveAuth()) {
            this.assertSyncObserved(2, true, true);
            AuthenticationSuccessEvent successEvent = (AuthenticationSuccessEvent)this.observer.syncEvents.get(0);
            SecurityIdentity identity = successEvent.getSecurityIdentity();
            Assertions.assertNotNull((Object)identity);
            Assertions.assertEquals((Object)"admin", (Object)identity.getPrincipal().getName());
            RoutingContext routingContext = (RoutingContext)successEvent.getEventProperties().get(RoutingContext.class.getName());
            Assertions.assertNotNull((Object)routingContext);
            Assertions.assertTrue((boolean)routingContext.request().path().endsWith("/unsecured/permitAll"));
            AuthorizationSuccessEvent authZSuccessEvent = (AuthorizationSuccessEvent)this.observer.syncEvents.get(1);
            Assertions.assertNull((Object)authZSuccessEvent.getSecurityIdentity());
            Assertions.assertEquals((Object)routingContext, authZSuccessEvent.getEventProperties().get(RoutingContext.class.getName()));
        } else {
            this.assertSyncObserved(1, true, true);
            AuthorizationSuccessEvent authZSuccessEvent = (AuthorizationSuccessEvent)this.observer.syncEvents.get(0);
            Assertions.assertNull((Object)authZSuccessEvent.getSecurityIdentity());
            Assertions.assertNotNull(authZSuccessEvent.getEventProperties().get(RoutingContext.class.getName()));
        }
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/unsecured/permitAll", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"permitAll"), new Matcher[0]);
        if (this.isProactiveAuth()) {
            this.assertSyncObserved(3, true, true);
        } else {
            this.assertSyncObserved(2, true, true);
        }
        this.assertAsyncAuthZFailureObserved(0);
    }

    private void assertSyncObserved(int count) {
        this.assertSyncObserved(count, true, false);
    }

    private void assertSyncObserved(int count, boolean expectRoutingContext, boolean isPermitAll) {
        Assertions.assertEquals((int)count, (int)this.observer.syncEvents.size());
        if (count > 0) {
            if (!isPermitAll) {
                Assertions.assertTrue((boolean)this.observer.syncEvents.stream().allMatch(e -> e.getSecurityIdentity() != null));
            }
            if (expectRoutingContext) {
                Assertions.assertTrue((boolean)this.observer.syncEvents.stream().map(e -> e.getEventProperties().get(RoutingContext.class.getName())).allMatch(Objects::nonNull));
            }
        }
    }

    private void assertAsyncAuthZFailureObserved(int count) {
        this.assertAsyncAuthZFailureObserved(count, true);
    }

    private void assertAsyncAuthZFailureObserved(int count, boolean expectRoutingContext) {
        Awaitility.await().atMost(Duration.ofSeconds(2L)).untilAsserted(() -> Assertions.assertEquals((int)count, (int)this.observer.asyncAuthZFailureEvents.size()));
        if (count > 0) {
            Assertions.assertTrue((boolean)this.observer.asyncAuthZFailureEvents.stream().allMatch(e -> e.getSecurityIdentity() != null));
            if (expectRoutingContext) {
                Assertions.assertTrue((boolean)this.observer.asyncAuthZFailureEvents.stream().map(e -> e.getEventProperties().get(RoutingContext.class.getName())).allMatch(Objects::nonNull));
            }
        }
    }

    @Singleton
    public static class EventObserver {
        private final List<SecurityEvent> syncEvents = new CopyOnWriteArrayList<SecurityEvent>();
        private final List<AuthorizationFailureEvent> asyncAuthZFailureEvents = new CopyOnWriteArrayList<AuthorizationFailureEvent>();
        private final List<AuthenticationFailureEvent> authNFailureEvents = new CopyOnWriteArrayList<AuthenticationFailureEvent>();

        void observe(@Observes SecurityEvent securityEvent) {
            this.syncEvents.add(securityEvent);
        }

        void observe(@Observes AuthenticationFailureEvent authenticationFailureEvent) {
            this.authNFailureEvents.add(authenticationFailureEvent);
        }

        void observe(@ObservesAsync AuthorizationFailureEvent authorizationFailureEvent) {
            this.asyncAuthZFailureEvents.add(authorizationFailureEvent);
            RoutingContext routingContext = (RoutingContext)authorizationFailureEvent.getEventProperties().get(RoutingContext.class.getName());
        }
    }
}

