/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.test.security;

import io.quarkus.arc.Arc;
import io.quarkus.resteasy.reactive.server.test.security.AuthMechRequest;
import io.quarkus.resteasy.reactive.server.test.security.TestTrustedIdentityProvider;
import io.quarkus.security.Authenticated;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.test.utils.TestIdentityController;
import io.quarkus.security.test.utils.TestIdentityProvider;
import io.quarkus.test.QuarkusUnitTest;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.annotation.BasicAuthentication;
import io.quarkus.vertx.http.runtime.security.annotation.FormAuthentication;
import io.quarkus.vertx.http.runtime.security.annotation.HttpAuthenticationMechanism;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class AnnotationBasedAuthMechanismSelectionTest {
    private static final List<AuthMechRequest> REQUESTS = List.of(new AuthMechRequest("annotated-http-permissions/no-roles-allowed-basic").basic().noRbacAnnotation(), new AuthMechRequest("unannotated-http-permissions/no-roles-allowed-basic").basic().noRbacAnnotation(), new AuthMechRequest("annotated-http-permissions/roles-allowed-annotation-basic-auth").basic(), new AuthMechRequest("unannotated-http-permissions/roles-allowed-annotation-basic-auth").basic(), new AuthMechRequest("annotated-http-permissions/unauthenticated-form").form().noRbacAnnotation(), new AuthMechRequest("unannotated-http-permissions/unauthenticated-form").form().noRbacAnnotation(), new AuthMechRequest("annotated-http-permissions/authenticated-form").form().authRequest(), new AuthMechRequest("unannotated-http-permissions/authenticated-form").form().authRequest(), new AuthMechRequest("unannotated-http-permissions/basic-class-level-interface").basic().noRbacAnnotation().pathAnnotationDeclaredOnInterface(), new AuthMechRequest("annotated-http-permissions/basic-class-level-interface").basic().noRbacAnnotation().pathAnnotationDeclaredOnInterface(), new AuthMechRequest("annotated-http-permissions/overridden-parent-class-endpoint").custom().noRbacAnnotation(), new AuthMechRequest("annotated-http-permissions/default-impl-custom-class-level-interface").custom().noRbacAnnotation(), new AuthMechRequest("unannotated-http-permissions/overridden-parent-class-endpoint").form().noRbacAnnotation(), new AuthMechRequest("unannotated-http-permissions/default-impl-custom-class-level-interface").basic().noRbacAnnotation().pathAnnotationDeclaredOnInterface(), new AuthMechRequest("annotated-http-permissions/default-form-method-level-interface").form().noRbacAnnotation().defaultAuthMech(), new AuthMechRequest("unannotated-http-permissions/default-form-method-level-interface").form().noRbacAnnotation().defaultAuthMech(), new AuthMechRequest("annotated-http-permissions/basic-method-level-interface").basic().noRbacAnnotation().defaultAuthMech(), new AuthMechRequest("unannotated-http-permissions/basic-method-level-interface").basic().noRbacAnnotation().defaultAuthMech(), new AuthMechRequest("annotated-http-permissions/custom-inherited").custom(), new AuthMechRequest("annotated-http-permissions/basic-inherited").basic().authRequest(), new AuthMechRequest("annotated-http-permissions/form-default").form().defaultAuthMech().authRequest(), new AuthMechRequest("annotated-http-permissions/custom").custom().noRbacAnnotation(), new AuthMechRequest("annotated-http-permissions/custom-roles-allowed").custom(), new AuthMechRequest("unannotated-http-permissions/deny-custom").custom().denyPolicy(), new AuthMechRequest("annotated-http-permissions/roles-allowed-jax-rs-policy").form());
    @RegisterExtension
    static QuarkusUnitTest runner = new QuarkusUnitTest().withApplicationRoot(jar -> ((JavaArchive)jar.addClasses(new Class[]{TestIdentityProvider.class, TestIdentityController.class, CustomBasicAuthMechanism.class, AbstractHttpPermissionsResource.class, AnnotatedHttpPermissionsResource.class, AbstractAnnotatedHttpPermissionsResource.class, UnannotatedHttpPermissionsResource.class, HttpPermissionsResourceClassLevelInterface.class, HttpPermissionsResourceMethodLevelInterface.class, AuthMechRequest.class, TestTrustedIdentityProvider.class})).addAsResource((Asset)new StringAsset("quarkus.http.auth.proactive=false\nquarkus.http.auth.form.enabled=true\nquarkus.http.auth.form.login-page=\nquarkus.http.auth.form.error-page=\nquarkus.http.auth.form.landing-page=\nquarkus.http.auth.basic=true\nquarkus.http.auth.permission.roles1.paths=/annotated-http-permissions/roles-allowed,/unannotated-http-permissions/roles-allowed\nquarkus.http.auth.permission.roles1.policy=roles1\nquarkus.http.auth.permission.jax-rs.paths=/annotated-http-permissions/roles-allowed-jax-rs-policy\nquarkus.http.auth.permission.jax-rs.policy=roles1\nquarkus.http.auth.permission.jax-rs.applies-to=JAXRS\nquarkus.http.auth.policy.roles1.roles-allowed=admin\nquarkus.http.auth.permission.authenticated.auth-mechanism=basic\nquarkus.http.auth.permission.authenticated.paths=/annotated-http-permissions/authenticated,/unannotated-http-permissions/authenticated\nquarkus.http.auth.permission.authenticated.policy=authenticated\nquarkus.http.auth.permission.same-mechanism.paths=/annotated-http-permissions/same-mech\nquarkus.http.auth.permission.same-mechanism.policy=authenticated\nquarkus.http.auth.permission.same-mechanism.auth-mechanism=custom\nquarkus.http.auth.permission.diff-mechanism.paths=/annotated-http-permissions/diff-mech\nquarkus.http.auth.permission.diff-mechanism.policy=authenticated\nquarkus.http.auth.permission.diff-mechanism.auth-mechanism=basic\nquarkus.http.auth.permission.permit1.paths=/annotated-http-permissions/permit,/unannotated-http-permissions/permit\nquarkus.http.auth.permission.permit1.policy=permit\nquarkus.http.auth.permission.deny1.paths=/annotated-http-permissions/deny,/unannotated-http-permissions/deny\nquarkus.http.auth.permission.deny1.policy=deny\n"), "application.properties"));

    @BeforeAll
    public static void setupUsers() {
        TestIdentityController.resetRoles().add("admin", "admin", new String[]{"admin"}).add("user", "user", new String[]{"user"});
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @MethodSource(value={"authMechanismRequestsIdxs"})
    @ParameterizedTest
    public void testAuthMechanismSelection(int idx) {
        AuthMechRequest in = REQUESTS.get(idx);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)in.requestSpecification.get().get(in.path, new Object[0])).then()).statusCode(in.expectedStatus)).body(CoreMatchers.is((Object)in.expectedBody), new Matcher[0])).header(in.expectedHeaderKey, in.expectedHeaderVal);
        if (in.authRequired && in.unauthorizedRequestSpec != null) {
            ((ValidatableResponse)((ValidatableResponse)((Response)in.unauthorizedRequestSpec.get().get(in.path, new Object[0])).then()).statusCode(403)).header(in.expectedHeaderKey, in.expectedHeaderVal);
        }
        if (in.authRequired && in.unauthenticatedRequestSpec != null) {
            ((ValidatableResponse)((ValidatableResponse)((Response)in.unauthenticatedRequestSpec.get().get(in.path, new Object[0])).then()).statusCode(401)).header(in.expectedHeaderKey, in.expectedHeaderVal);
        }
        if (in.requestUsingOtherAuthMech != null) {
            if (in.authRequired) {
                ((ValidatableResponse)((ValidatableResponse)((Response)in.requestUsingOtherAuthMech.get().get(in.path, new Object[0])).then()).statusCode(401)).header(in.expectedHeaderKey, in.expectedHeaderVal);
            } else {
                ((ValidatableResponse)((ValidatableResponse)((Response)in.requestUsingOtherAuthMech.get().get(in.path, new Object[0])).then()).header(in.expectedHeaderKey, in.expectedHeaderVal)).statusCode(401);
            }
        }
    }

    @Test
    public void testHttpPolicyApplied() {
        ((ValidatableResponse)((Response)RestAssured.given().get("/annotated-http-permissions/authenticated", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)RestAssured.given().get("/unannotated-http-permissions/authenticated", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)RestAssured.given().get("/annotated-http-permissions/deny", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)RestAssured.given().get("/unannotated-http-permissions/deny", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)AuthMechRequest.requestWithBasicAuthUser().get("/annotated-http-permissions/roles-allowed", new Object[0])).then()).statusCode(403);
        ((ValidatableResponse)((Response)AuthMechRequest.requestWithFormAuth("user").get("/unannotated-http-permissions/roles-allowed", new Object[0])).then()).statusCode(403);
        ((ValidatableResponse)((Response)AuthMechRequest.requestWithFormAuth("admin").get("/annotated-http-permissions/roles-allowed", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)AuthMechRequest.requestWithFormAuth("admin").get("/unannotated-http-permissions/roles-allowed", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)AuthMechRequest.requestWithFormAuth("user").get("/unannotated-http-permissions/authenticated", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)RestAssured.given().get("/annotated-http-permissions/permit", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)RestAssured.given().get("/unannotated-http-permissions/permit", new Object[0])).then()).statusCode(401);
    }

    @Test
    public void testBothHttpSecPolicyAndAnnotationApplied() {
        ((ValidatableResponse)((Response)AuthMechRequest.requestWithBasicAuthUser().get("/annotated-http-permissions/authenticated", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)AuthMechRequest.requestWithFormAuth("user").get("/annotated-http-permissions/authenticated", new Object[0])).then()).statusCode(401);
        ((ValidatableResponse)((Response)AuthMechRequest.requestWithFormAuth("user").auth().preemptive().basic("admin", "admin").get("/annotated-http-permissions/authenticated", new Object[0])).then()).statusCode(401);
    }

    @Test
    public void testAuthenticatedHttpPolicyUsingSameMechanism() {
        ((ValidatableResponse)((Response)AuthMechRequest.requestWithBasicAuthUser().get("/annotated-http-permissions/same-mech", new Object[0])).then()).statusCode(200);
    }

    @Test
    public void testAuthenticatedHttpPolicyUsingDiffMechanism() {
        ((ValidatableResponse)((Response)AuthMechRequest.requestWithBasicAuthUser().get("/annotated-http-permissions/diff-mech", new Object[0])).then()).statusCode(401);
    }

    private static IntStream authMechanismRequestsIdxs() {
        return IntStream.range(0, REQUESTS.size());
    }

    @Singleton
    public static class CustomBasicAuthMechanism
    implements io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism {
        static final String CUSTOM_AUTH_HEADER_KEY = CustomBasicAuthMechanism.class.getName();
        private final BasicAuthenticationMechanism delegate;

        public CustomBasicAuthMechanism(BasicAuthenticationMechanism delegate) {
            this.delegate = delegate;
        }

        public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
            context.response().putHeader(CUSTOM_AUTH_HEADER_KEY, "true");
            return this.delegate.authenticate(context, identityProviderManager);
        }

        public Uni<ChallengeData> getChallenge(RoutingContext context) {
            return this.delegate.getChallenge(context);
        }

        public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
            return this.delegate.getCredentialTypes();
        }

        public Uni<Boolean> sendChallenge(RoutingContext context) {
            return this.delegate.sendChallenge(context);
        }

        public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
            return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, "custom"));
        }

        public int getPriority() {
            return this.delegate.getPriority();
        }
    }

    @FormAuthentication
    public static abstract class AbstractHttpPermissionsResource
    implements HttpPermissionsResourceClassLevelInterface,
    HttpPermissionsResourceMethodLevelInterface {
        @Inject
        SecurityIdentity securityIdentity;

        @Path(value="permit")
        @GET
        public String permit() {
            return "permit";
        }

        @Path(value="deny")
        @GET
        public String deny() {
            return "deny";
        }

        @Path(value="roles-allowed")
        @GET
        public String rolesAllowed() {
            return "roles-allowed";
        }

        @Path(value="roles-allowed-jax-rs-policy")
        @GET
        public String rolesAllowedJaxRsPolicy() {
            return "roles-allowed-jax-rs-policy";
        }

        @Path(value="authenticated")
        @GET
        public String authenticated() {
            return "authenticated";
        }

        @Authenticated
        @Path(value="authenticated-form")
        @GET
        public String authenticatedNoPolicyFormAuthMech() {
            return "authenticated-form";
        }

        @Path(value="unauthenticated-form")
        @GET
        public String unauthenticatedNoPolicyFormAuthMech() {
            return this.securityIdentity.getPrincipal().getName();
        }

        @RolesAllowed(value={"admin"})
        @BasicAuthentication
        @Path(value="roles-allowed-annotation-basic-auth")
        @GET
        public String rolesAllowedNoPolicyBasicAuthMech() {
            return "roles-allowed-annotation-basic-auth";
        }

        @BasicAuthentication
        @Path(value="no-roles-allowed-basic")
        @GET
        public String noPolicyBasicAuthMech() {
            return this.securityIdentity.getPrincipal().getName();
        }

        @RolesAllowed(value={"admin"})
        @Path(value="overridden-parent-class-endpoint")
        @GET
        public String overriddenParentClassEndpoint() {
            return this.securityIdentity.getPrincipal().getName();
        }
    }

    @HttpAuthenticationMechanism(value="custom")
    @Path(value="annotated-http-permissions")
    public static class AnnotatedHttpPermissionsResource
    extends AbstractAnnotatedHttpPermissionsResource {
        @Authenticated
        @BasicAuthentication
        @Path(value="basic-inherited")
        @GET
        public String basicInherited() {
            return "basic-inherited";
        }

        @RolesAllowed(value={"admin"})
        @Path(value="custom-inherited")
        @GET
        public String customInherited() {
            return "custom-inherited";
        }

        @Override
        @Path(value="default-impl-custom-class-level-interface")
        @GET
        public String defaultImplementedClassLevelInterfaceMethod() {
            return super.defaultImplementedClassLevelInterfaceMethod();
        }

        @Override
        @Path(value="overridden-parent-class-endpoint")
        @GET
        public String overriddenParentClassEndpoint() {
            return super.overriddenParentClassEndpoint();
        }

        @GET
        @HttpAuthenticationMechanism(value="custom")
        @Path(value="same-mech")
        public String authPolicyIsUsingSameMechAsAnnotation() {
            return "same-mech";
        }

        @GET
        @HttpAuthenticationMechanism(value="custom")
        @Path(value="diff-mech")
        public String authPolicyIsUsingDiffMechAsAnnotation() {
            return "diff-mech";
        }
    }

    public static class AbstractAnnotatedHttpPermissionsResource
    extends AbstractHttpPermissionsResource {
        @RolesAllowed(value={"admin"})
        @HttpAuthenticationMechanism(value="custom")
        @Path(value="custom-roles-allowed")
        @GET
        public String noPolicyCustomAuthMechRolesAllowed() {
            return "custom-roles-allowed";
        }

        @HttpAuthenticationMechanism(value="custom")
        @Path(value="custom")
        @GET
        public String noPolicyCustomAuthMech() {
            return this.securityIdentity.getPrincipal().getName();
        }

        @Authenticated
        @Path(value="form-default")
        @GET
        public String formDefault() {
            return "form-default";
        }
    }

    @Path(value="unannotated-http-permissions")
    public static class UnannotatedHttpPermissionsResource
    extends AbstractHttpPermissionsResource {
        @HttpAuthenticationMechanism(value="custom")
        @DenyAll
        @Path(value="deny-custom")
        @GET
        public String denyCustomAuthMechanism() {
            return "ignored";
        }

        @Override
        public String defaultImplementedClassLevelInterfaceMethod() {
            return super.defaultImplementedClassLevelInterfaceMethod();
        }

        @Override
        public String overriddenParentClassEndpoint() {
            return super.overriddenParentClassEndpoint();
        }
    }

    @BasicAuthentication
    public static interface HttpPermissionsResourceClassLevelInterface {
        @Path(value="basic-class-level-interface")
        @GET
        default public String basicClassLevelInterface() {
            return ((SecurityIdentity)Arc.container().instance(SecurityIdentity.class, new Annotation[0]).get()).getPrincipal().getName();
        }

        @Path(value="default-impl-custom-class-level-interface")
        @GET
        default public String defaultImplementedClassLevelInterfaceMethod() {
            return ((SecurityIdentity)Arc.container().instance(SecurityIdentity.class, new Annotation[0]).get()).getPrincipal().getName();
        }
    }

    public static interface HttpPermissionsResourceMethodLevelInterface {
        @Authenticated
        @BasicAuthentication
        @Path(value="basic-method-level-interface")
        @GET
        default public String basicMethodLevelInterface() {
            return ((SecurityIdentity)Arc.container().instance(SecurityIdentity.class, new Annotation[0]).get()).getPrincipal().getName();
        }

        @Authenticated
        @Path(value="default-form-method-level-interface")
        @GET
        default public String defaultFormMethodLevelInterface() {
            return ((SecurityIdentity)Arc.container().instance(SecurityIdentity.class, new Annotation[0]).get()).getPrincipal().getName();
        }
    }
}

